/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.history;

import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.camunda.bpm.engine.rest.dto.runtime.SerializedObjectDto;

public class HistoricVariableInstanceDto {
    private String id;
    private String name;
    private String type;
    private Object value;
    private String processInstanceId;
    private String activityInstanceId;
    private String errorMessage;

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static HistoricVariableInstanceDto fromHistoricVariableInstance(HistoricVariableInstance historicVariableInstance) {
        HistoricVariableInstanceEntity entity = (HistoricVariableInstanceEntity)historicVariableInstance;
        HistoricVariableInstanceDto dto = new HistoricVariableInstanceDto();
        dto.id = entity.getId();
        dto.name = entity.getVariableName();
        dto.processInstanceId = entity.getProcessInstanceId();
        dto.activityInstanceId = entity.getActivtyInstanceId();
        if ("serializable".equals(entity.getVariableType().getTypeName())) {
            if (entity.getValue() != null) {
                dto.value = new SerializedObjectDto(entity.getValue());
            }
        } else {
            dto.value = entity.getValue();
        }
        dto.type = entity.getVariableType().getTypeNameForValue(entity.getValue());
        dto.errorMessage = entity.getErrorMessage();
        return dto;
    }
}

