/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.runtime;

import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.rest.dto.SuspensionStateDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;

public class JobSuspensionStateDto
extends SuspensionStateDto {
    private String jobId;
    private String jobDefinitionId;
    private String processInstanceId;
    private String processDefinitionId;
    private String processDefinitionKey;

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public void setJobDefinitionId(String jobDefinitionId) {
        this.jobDefinitionId = jobDefinitionId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public void updateSuspensionState(ProcessEngine engine) {
        int params = (this.jobId != null ? 1 : 0) + (this.jobDefinitionId != null ? 1 : 0) + (this.processInstanceId != null ? 1 : 0) + (this.processDefinitionId != null ? 1 : 0) + (this.processDefinitionKey != null ? 1 : 0);
        if (params > 1) {
            String message = "Only one of jobId, jobDefinitionId, processInstanceId, processDefinitionId or processDefinitionKey should be set to update the suspension state.";
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, message);
        }
        ManagementService managementService = engine.getManagementService();
        if (this.jobId != null) {
            if (this.getSuspended()) {
                managementService.suspendJobById(this.jobId);
            } else {
                managementService.activateJobById(this.jobId);
            }
        } else if (this.jobDefinitionId != null) {
            if (this.getSuspended()) {
                managementService.suspendJobByJobDefinitionId(this.jobDefinitionId);
            } else {
                managementService.activateJobByJobDefinitionId(this.jobDefinitionId);
            }
        } else if (this.processInstanceId != null) {
            if (this.getSuspended()) {
                managementService.suspendJobByProcessInstanceId(this.processInstanceId);
            } else {
                managementService.activateJobByProcessInstanceId(this.processInstanceId);
            }
        } else if (this.processDefinitionId != null) {
            if (this.getSuspended()) {
                managementService.suspendJobByProcessDefinitionId(this.processDefinitionId);
            } else {
                managementService.activateJobByProcessDefinitionId(this.processDefinitionId);
            }
        } else if (this.processDefinitionKey != null) {
            if (this.getSuspended()) {
                managementService.suspendJobByProcessDefinitionKey(this.processDefinitionKey);
            } else {
                managementService.activateJobByProcessDefinitionKey(this.processDefinitionKey);
            }
        } else {
            String message = "Either jobId, jobDefinitionId, processInstanceId, processDefinitionId or processDefinitionKey should be set to update the suspension state.";
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, message);
        }
    }
}

