/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.VariableQueryParameterDto;
import org.camunda.bpm.engine.rest.dto.converter.BooleanConverter;
import org.camunda.bpm.engine.rest.dto.converter.DateConverter;
import org.camunda.bpm.engine.rest.dto.converter.DelegationStateConverter;
import org.camunda.bpm.engine.rest.dto.converter.IntegerConverter;
import org.camunda.bpm.engine.rest.dto.converter.StringArrayConverter;
import org.camunda.bpm.engine.rest.dto.converter.StringListConverter;
import org.camunda.bpm.engine.rest.dto.converter.VariableListConverter;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.task.DelegationState;
import org.camunda.bpm.engine.task.TaskQuery;

public class TaskQueryDto
extends AbstractQueryDto<TaskQuery> {
    private static final String SORT_BY_PROCESS_INSTANCE_ID_VALUE = "instanceId";
    private static final String SORT_BY_DUE_DATE_VALUE = "dueDate";
    private static final String SORT_BY_FOLLOW_UP_VALUE = "followUpDate";
    private static final String SORT_BY_EXECUTION_ID_VALUE = "executionId";
    private static final String SORT_BY_ASSIGNEE_VALUE = "assignee";
    private static final String SORT_BY_CREATE_TIME_VALUE = "created";
    private static final String SORT_BY_DESCRIPTION_VALUE = "description";
    private static final String SORT_BY_ID_VALUE = "id";
    private static final String SORT_BY_NAME_VALUE = "name";
    private static final String SORT_BY_PRIORITY_VALUE = "priority";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList();
    private String processInstanceBusinessKey;
    private String processInstanceBusinessKeyLike;
    private String processDefinitionKey;
    private String processDefinitionId;
    private String executionId;
    private String[] activityInstanceIdIn;
    private String processDefinitionName;
    private String processDefinitionNameLike;
    private String processInstanceId;
    private String assignee;
    private String assigneeLike;
    private String candidateGroup;
    private String candidateUser;
    private String taskDefinitionKey;
    private String taskDefinitionKeyLike;
    private String description;
    private String descriptionLike;
    private String involvedUser;
    private Integer maxPriority;
    private Integer minPriority;
    private String name;
    private String nameLike;
    private String owner;
    private Integer priority;
    private Boolean unassigned;
    private Boolean active;
    private Boolean suspended;
    private Date dueAfter;
    private Date dueBefore;
    private Date dueDate;
    private Date followUpAfter;
    private Date followUpBefore;
    private Date followUpDate;
    private Date createdAfter;
    private Date createdBefore;
    private Date createdOn;
    private DelegationState delegationState;
    private List<String> candidateGroups;
    private List<VariableQueryParameterDto> taskVariables;
    private List<VariableQueryParameterDto> processVariables;

    public TaskQueryDto() {
    }

    public TaskQueryDto(MultivaluedMap<String, String> queryParameters) {
        super(queryParameters);
    }

    @CamundaQueryParam(value="processInstanceBusinessKey")
    public void setProcessInstanceBusinessKey(String businessKey) {
        this.processInstanceBusinessKey = businessKey;
    }

    @CamundaQueryParam(value="processInstanceBusinessKeyLike")
    public void setProcessInstanceBusinessKeyLike(String businessKeyLike) {
        this.processInstanceBusinessKeyLike = businessKeyLike;
    }

    @CamundaQueryParam(value="processDefinitionKey")
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @CamundaQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @CamundaQueryParam(value="executionId")
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @CamundaQueryParam(value="activityInstanceIdIn", converter=StringArrayConverter.class)
    public void setActivityInstanceIdIn(String[] activityInstanceIdIn) {
        this.activityInstanceIdIn = activityInstanceIdIn;
    }

    @CamundaQueryParam(value="processDefinitionName")
    public void setProcessDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
    }

    @CamundaQueryParam(value="processDefinitionNameLike")
    public void setProcessDefinitionNameLike(String processDefinitionNameLike) {
        this.processDefinitionNameLike = processDefinitionNameLike;
    }

    @CamundaQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @CamundaQueryParam(value="assignee")
    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    @CamundaQueryParam(value="assigneeLike")
    public void setAssigneeLike(String assigneeLike) {
        this.assigneeLike = assigneeLike;
    }

    @CamundaQueryParam(value="candidateGroup")
    public void setCandidateGroup(String candidateGroup) {
        this.candidateGroup = candidateGroup;
    }

    @CamundaQueryParam(value="candidateUser")
    public void setCandidateUser(String candidateUser) {
        this.candidateUser = candidateUser;
    }

    @CamundaQueryParam(value="taskDefinitionKey")
    public void setTaskDefinitionKey(String taskDefinitionKey) {
        this.taskDefinitionKey = taskDefinitionKey;
    }

    @CamundaQueryParam(value="taskDefinitionKeyLike")
    public void setTaskDefinitionKeyLike(String taskDefinitionKeyLike) {
        this.taskDefinitionKeyLike = taskDefinitionKeyLike;
    }

    @CamundaQueryParam(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @CamundaQueryParam(value="descriptionLike")
    public void setDescriptionLike(String descriptionLike) {
        this.descriptionLike = descriptionLike;
    }

    @CamundaQueryParam(value="involvedUser")
    public void setInvolvedUser(String involvedUser) {
        this.involvedUser = involvedUser;
    }

    @CamundaQueryParam(value="maxPriority", converter=IntegerConverter.class)
    public void setMaxPriority(Integer maxPriority) {
        this.maxPriority = maxPriority;
    }

    @CamundaQueryParam(value="minPriority", converter=IntegerConverter.class)
    public void setMinPriority(Integer minPriority) {
        this.minPriority = minPriority;
    }

    @CamundaQueryParam(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @CamundaQueryParam(value="nameLike")
    public void setNameLike(String nameLike) {
        this.nameLike = nameLike;
    }

    @CamundaQueryParam(value="owner")
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @CamundaQueryParam(value="priority", converter=IntegerConverter.class)
    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    @CamundaQueryParam(value="unassigned", converter=BooleanConverter.class)
    public void setUnassigned(Boolean unassigned) {
        this.unassigned = unassigned;
    }

    @CamundaQueryParam(value="active", converter=BooleanConverter.class)
    public void setActive(Boolean active) {
        this.active = active;
    }

    @CamundaQueryParam(value="suspended", converter=BooleanConverter.class)
    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    @CamundaQueryParam(value="dueAfter", converter=DateConverter.class)
    public void setDueAfter(Date dueAfter) {
        this.dueAfter = dueAfter;
    }

    @CamundaQueryParam(value="dueBefore", converter=DateConverter.class)
    public void setDueBefore(Date dueBefore) {
        this.dueBefore = dueBefore;
    }

    @CamundaQueryParam(value="due", converter=DateConverter.class)
    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    @CamundaQueryParam(value="followUpAfter", converter=DateConverter.class)
    public void setFollowUpAfter(Date followUpAfter) {
        this.followUpAfter = followUpAfter;
    }

    @CamundaQueryParam(value="followUpBefore", converter=DateConverter.class)
    public void setFollowUpBefore(Date followUpBefore) {
        this.followUpBefore = followUpBefore;
    }

    @CamundaQueryParam(value="followUp", converter=DateConverter.class)
    public void setFollowUpDate(Date followUp) {
        this.followUpDate = followUp;
    }

    @CamundaQueryParam(value="createdAfter", converter=DateConverter.class)
    public void setCreatedAfter(Date createdAfter) {
        this.createdAfter = createdAfter;
    }

    @CamundaQueryParam(value="createdBefore", converter=DateConverter.class)
    public void setCreatedBefore(Date createdBefore) {
        this.createdBefore = createdBefore;
    }

    @CamundaQueryParam(value="created", converter=DateConverter.class)
    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    @CamundaQueryParam(value="delegationState", converter=DelegationStateConverter.class)
    public void setDelegationState(DelegationState taskDelegationState) {
        this.delegationState = taskDelegationState;
    }

    @CamundaQueryParam(value="candidateGroups", converter=StringListConverter.class)
    public void setCandidateGroups(List<String> candidateGroups) {
        this.candidateGroups = candidateGroups;
    }

    @CamundaQueryParam(value="taskVariables", converter=VariableListConverter.class)
    public void setTaskVariables(List<VariableQueryParameterDto> taskVariables) {
        this.taskVariables = taskVariables;
    }

    @CamundaQueryParam(value="processVariables", converter=VariableListConverter.class)
    public void setProcessVariables(List<VariableQueryParameterDto> processVariables) {
        this.processVariables = processVariables;
    }

    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    protected TaskQuery createNewQuery(ProcessEngine engine) {
        return engine.getTaskService().createTaskQuery();
    }

    protected void applyFilters(TaskQuery query) {
        Object variableValue;
        String op;
        String variableName;
        if (this.processInstanceBusinessKey != null) {
            query.processInstanceBusinessKey(this.processInstanceBusinessKey);
        }
        if (this.processInstanceBusinessKeyLike != null) {
            query.processInstanceBusinessKeyLike(this.processInstanceBusinessKeyLike);
        }
        if (this.processDefinitionKey != null) {
            query.processDefinitionKey(this.processDefinitionKey);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.executionId != null) {
            query.executionId(this.executionId);
        }
        if (this.activityInstanceIdIn != null && this.activityInstanceIdIn.length > 0) {
            query.activityInstanceIdIn(this.activityInstanceIdIn);
        }
        if (this.processDefinitionName != null) {
            query.processDefinitionName(this.processDefinitionName);
        }
        if (this.processDefinitionNameLike != null) {
            query.processDefinitionNameLike(this.processDefinitionNameLike);
        }
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.assignee != null) {
            query.taskAssignee(this.assignee);
        }
        if (this.assigneeLike != null) {
            query.taskAssigneeLike(this.assigneeLike);
        }
        if (this.candidateGroup != null) {
            query.taskCandidateGroup(this.candidateGroup);
        }
        if (this.candidateUser != null) {
            query.taskCandidateUser(this.candidateUser);
        }
        if (this.taskDefinitionKey != null) {
            query.taskDefinitionKey(this.taskDefinitionKey);
        }
        if (this.taskDefinitionKeyLike != null) {
            query.taskDefinitionKeyLike(this.taskDefinitionKeyLike);
        }
        if (this.description != null) {
            query.taskDescription(this.description);
        }
        if (this.descriptionLike != null) {
            query.taskDescriptionLike(this.descriptionLike);
        }
        if (this.involvedUser != null) {
            query.taskInvolvedUser(this.involvedUser);
        }
        if (this.maxPriority != null) {
            query.taskMaxPriority(this.maxPriority);
        }
        if (this.minPriority != null) {
            query.taskMinPriority(this.minPriority);
        }
        if (this.name != null) {
            query.taskName(this.name);
        }
        if (this.nameLike != null) {
            query.taskNameLike(this.nameLike);
        }
        if (this.owner != null) {
            query.taskOwner(this.owner);
        }
        if (this.priority != null) {
            query.taskPriority(this.priority);
        }
        if (this.unassigned != null && this.unassigned.booleanValue()) {
            query.taskUnassigned();
        }
        if (this.dueAfter != null) {
            query.dueAfter(this.dueAfter);
        }
        if (this.dueBefore != null) {
            query.dueBefore(this.dueBefore);
        }
        if (this.dueDate != null) {
            query.dueDate(this.dueDate);
        }
        if (this.followUpAfter != null) {
            query.followUpAfter(this.followUpAfter);
        }
        if (this.followUpBefore != null) {
            query.followUpBefore(this.followUpBefore);
        }
        if (this.followUpDate != null) {
            query.followUpDate(this.followUpDate);
        }
        if (this.createdAfter != null) {
            query.taskCreatedAfter(this.createdAfter);
        }
        if (this.createdBefore != null) {
            query.taskCreatedBefore(this.createdBefore);
        }
        if (this.createdOn != null) {
            query.taskCreatedOn(this.createdOn);
        }
        if (this.delegationState != null) {
            query.taskDelegationState(this.delegationState);
        }
        if (this.candidateGroups != null) {
            query.taskCandidateGroupIn(this.candidateGroups);
        }
        if (this.active != null && this.active.booleanValue()) {
            query.active();
        }
        if (this.suspended != null && this.suspended.booleanValue()) {
            query.suspended();
        }
        if (this.taskVariables != null) {
            for (VariableQueryParameterDto variableQueryParam : this.taskVariables) {
                variableName = variableQueryParam.getName();
                op = variableQueryParam.getOperator();
                variableValue = variableQueryParam.getValue();
                if (op.equals("eq")) {
                    query.taskVariableValueEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("neq")) {
                    query.taskVariableValueNotEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("gt")) {
                    query.taskVariableValueGreaterThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("gteq")) {
                    query.taskVariableValueGreaterThanOrEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("lt")) {
                    query.taskVariableValueLessThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("lteq")) {
                    query.taskVariableValueLessThanOrEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("like")) {
                    query.taskVariableValueLike(variableName, String.valueOf(variableValue));
                    continue;
                }
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Invalid task variable comparator specified: " + op);
            }
        }
        if (this.processVariables != null) {
            for (VariableQueryParameterDto variableQueryParam : this.processVariables) {
                variableName = variableQueryParam.getName();
                op = variableQueryParam.getOperator();
                variableValue = variableQueryParam.getValue();
                if (op.equals("eq")) {
                    query.processVariableValueEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("neq")) {
                    query.processVariableValueNotEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("gt")) {
                    query.processVariableValueGreaterThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("gteq")) {
                    query.processVariableValueGreaterThanOrEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("lt")) {
                    query.processVariableValueLessThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("lteq")) {
                    query.processVariableValueLessThanOrEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("like")) {
                    query.processVariableValueLike(variableName, String.valueOf(variableValue));
                    continue;
                }
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Invalid process variable comparator specified: " + op);
            }
        }
    }

    protected void applySortingOptions(TaskQuery query) {
        if (this.sortBy != null) {
            if (this.sortBy.equals(SORT_BY_PROCESS_INSTANCE_ID_VALUE)) {
                query.orderByProcessInstanceId();
            } else if (this.sortBy.equals(SORT_BY_DUE_DATE_VALUE)) {
                query.orderByDueDate();
            } else if (this.sortBy.equals(SORT_BY_FOLLOW_UP_VALUE)) {
                query.orderByFollowUpDate();
            } else if (this.sortBy.equals(SORT_BY_EXECUTION_ID_VALUE)) {
                query.orderByExecutionId();
            } else if (this.sortBy.equals(SORT_BY_ASSIGNEE_VALUE)) {
                query.orderByTaskAssignee();
            } else if (this.sortBy.equals(SORT_BY_CREATE_TIME_VALUE)) {
                query.orderByTaskCreateTime();
            } else if (this.sortBy.equals(SORT_BY_DESCRIPTION_VALUE)) {
                query.orderByTaskDescription();
            } else if (this.sortBy.equals(SORT_BY_ID_VALUE)) {
                query.orderByTaskId();
            } else if (this.sortBy.equals(SORT_BY_NAME_VALUE)) {
                query.orderByTaskName();
            } else if (this.sortBy.equals(SORT_BY_PRIORITY_VALUE)) {
                query.orderByTaskPriority();
            }
        }
        if (this.sortOrder != null) {
            if (this.sortOrder.equals("asc")) {
                query.asc();
            } else if (this.sortOrder.equals("desc")) {
                query.desc();
            }
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_DUE_DATE_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_FOLLOW_UP_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_EXECUTION_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_ASSIGNEE_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_CREATE_TIME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_DESCRIPTION_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_NAME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PRIORITY_VALUE);
    }
}

