/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.rest.TaskRestService;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.task.TaskDto;
import org.camunda.bpm.engine.rest.dto.task.TaskQueryDto;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.camunda.bpm.engine.rest.sub.task.TaskResource;
import org.camunda.bpm.engine.rest.sub.task.impl.TaskResourceImpl;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;

public class TaskRestServiceImpl
extends AbstractRestProcessEngineAware
implements TaskRestService {
    public TaskRestServiceImpl() {
    }

    public TaskRestServiceImpl(String engineName) {
        super(engineName);
    }

    public List<TaskDto> getTasks(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        TaskQueryDto queryDto = new TaskQueryDto(uriInfo.getQueryParameters());
        return this.queryTasks(queryDto, firstResult, maxResults);
    }

    public List<TaskDto> queryTasks(TaskQueryDto queryDto, Integer firstResult, Integer maxResults) {
        ProcessEngine engine = this.getProcessEngine();
        TaskQuery query = (TaskQuery)queryDto.toQuery(engine);
        List matchingTasks = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        ArrayList<TaskDto> tasks = new ArrayList<TaskDto>();
        for (Task task : matchingTasks) {
            TaskDto returnTask = TaskDto.fromTask((Task)task);
            tasks.add(returnTask);
        }
        return tasks;
    }

    private List<Task> executePaginatedQuery(TaskQuery query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }

    public CountResultDto getTasksCount(UriInfo uriInfo) {
        TaskQueryDto queryDto = new TaskQueryDto(uriInfo.getQueryParameters());
        return this.queryTasksCount(queryDto);
    }

    public CountResultDto queryTasksCount(TaskQueryDto queryDto) {
        ProcessEngine engine = this.getProcessEngine();
        TaskQuery query = (TaskQuery)queryDto.toQuery(engine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }

    public TaskResource getTask(String id) {
        return new TaskResourceImpl(this.getProcessEngine(), id, this.relativeRootResourcePath);
    }
}

