/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.history.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.rest.dto.history.HistoricVariableInstanceDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.sub.history.HistoricVariableInstanceResource;

public class HistoricVariableInstanceResourceImpl
implements HistoricVariableInstanceResource {
    protected String variableId;
    protected ProcessEngine engine;

    public HistoricVariableInstanceResourceImpl(String variableId, ProcessEngine engine) {
        this.variableId = variableId;
        this.engine = engine;
    }

    public HistoricVariableInstanceDto getVariable() {
        HistoricVariableInstance variableInstance = (HistoricVariableInstance)this.baseQuery().disableBinaryFetching().singleResult();
        if (variableInstance != null) {
            return HistoricVariableInstanceDto.fromHistoricVariableInstance((HistoricVariableInstance)variableInstance);
        }
        throw new InvalidRequestException(Response.Status.NOT_FOUND, "Variable instance with Id '" + this.variableId + "' does not exist.");
    }

    public InputStream getBinaryVariable() {
        HistoricVariableInstance variableInstance = (HistoricVariableInstance)this.baseQuery().singleResult();
        if (variableInstance != null) {
            Object value = variableInstance.getValue();
            if (value instanceof byte[]) {
                return new ByteArrayInputStream((byte[])value);
            }
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Variable instance with Id '" + this.variableId + "' is not a binary variable.");
        }
        throw new InvalidRequestException(Response.Status.NOT_FOUND, "Variable instance with Id '" + this.variableId + "' does not exist.");
    }

    protected HistoricVariableInstanceQuery baseQuery() {
        return this.engine.getHistoryService().createHistoricVariableInstanceQuery().variableId(this.variableId);
    }
}

