/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.identity.impl;

import java.net.URI;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.rest.GroupRestService;
import org.camunda.bpm.engine.rest.dto.ResourceOptionsDto;
import org.camunda.bpm.engine.rest.sub.identity.GroupMembersResource;
import org.camunda.bpm.engine.rest.sub.identity.impl.AbstractIdentityResource;

public class GroupMembersResourceImpl
extends AbstractIdentityResource
implements GroupMembersResource {
    public GroupMembersResourceImpl(String processEngineName, String resourceId, String rootResourcePath) {
        super(processEngineName, (Resource)Resources.GROUP_MEMBERSHIP, resourceId);
        this.relativeRootResourcePath = rootResourcePath;
    }

    public void createGroupMember(String userId) {
        this.ensureNotReadOnly();
        this.identityService.createMembership(userId, this.resourceId);
    }

    public void deleteGroupMember(String userId) {
        this.ensureNotReadOnly();
        this.identityService.deleteMembership(userId, this.resourceId);
    }

    public ResourceOptionsDto availableOperations(UriInfo context) {
        ResourceOptionsDto dto = new ResourceOptionsDto();
        URI uri = context.getBaseUriBuilder().path(this.relativeRootResourcePath).path(GroupRestService.class).path(this.resourceId).path("/members").build(new Object[0]);
        if (!this.identityService.isReadOnly() && this.isAuthorized((Permission)Permissions.DELETE)) {
            dto.addReflexiveLink(uri, "DELETE", "delete");
        }
        if (!this.identityService.isReadOnly() && this.isAuthorized((Permission)Permissions.CREATE)) {
            dto.addReflexiveLink(uri, "PUT", "create");
        }
        return dto;
    }
}

