/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.runtime.impl;

import java.text.ParseException;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.rest.dto.runtime.EventSubscriptionDto;
import org.camunda.bpm.engine.rest.dto.runtime.ExecutionTriggerDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.sub.runtime.EventSubscriptionResource;
import org.camunda.bpm.engine.rest.util.DtoUtil;
import org.camunda.bpm.engine.runtime.EventSubscription;

public class MessageEventSubscriptionResource
implements EventSubscriptionResource {
    protected static final String MESSAGE_EVENT_TYPE = "message";
    private ProcessEngine engine;
    private String executionId;
    private String messageName;

    public MessageEventSubscriptionResource(ProcessEngine engine, String executionId, String messageName) {
        this.engine = engine;
        this.executionId = executionId;
        this.messageName = messageName;
    }

    public EventSubscriptionDto getEventSubscription() {
        RuntimeService runtimeService = this.engine.getRuntimeService();
        EventSubscription eventSubscription = (EventSubscription)runtimeService.createEventSubscriptionQuery().executionId(this.executionId).eventName(this.messageName).eventType(MESSAGE_EVENT_TYPE).singleResult();
        if (eventSubscription == null) {
            String errorMessage = String.format("Message event subscription for execution %s named %s does not exist", this.executionId, this.messageName);
            throw new InvalidRequestException(Response.Status.NOT_FOUND, errorMessage);
        }
        return EventSubscriptionDto.fromEventSubscription((EventSubscription)eventSubscription);
    }

    public void triggerEvent(ExecutionTriggerDto triggerDto) {
        RuntimeService runtimeService = this.engine.getRuntimeService();
        try {
            Map variables = DtoUtil.toMap((Map)triggerDto.getVariables());
            runtimeService.messageEventReceived(this.messageName, this.executionId, variables);
        }
        catch (ProcessEngineException e) {
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), "Cannot trigger message " + this.messageName + " for execution " + this.executionId + ": " + e.getMessage());
        }
        catch (NumberFormatException e) {
            String errorMessage = String.format("Cannot trigger message %s for execution %s: %s", this.messageName, this.executionId, e.getMessage());
            throw new RestException(Response.Status.BAD_REQUEST, (Exception)e, errorMessage);
        }
        catch (ParseException e) {
            String errorMessage = String.format("Cannot trigger message %s: %s", this.messageName, this.executionId, e.getMessage());
            throw new RestException(Response.Status.BAD_REQUEST, (Exception)e, errorMessage);
        }
        catch (IllegalArgumentException e) {
            String errorMessage = String.format("Cannot trigger message %s: %s", this.messageName, this.executionId, e.getMessage());
            throw new RestException(Response.Status.BAD_REQUEST, errorMessage);
        }
    }
}

