/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.task.impl;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.form.FormData;
import org.camunda.bpm.engine.form.TaskFormData;
import org.camunda.bpm.engine.rest.dto.task.CompleteTaskDto;
import org.camunda.bpm.engine.rest.dto.task.FormDto;
import org.camunda.bpm.engine.rest.dto.task.IdentityLinkDto;
import org.camunda.bpm.engine.rest.dto.task.TaskDto;
import org.camunda.bpm.engine.rest.dto.task.UserIdDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.sub.VariableResource;
import org.camunda.bpm.engine.rest.sub.task.TaskAttachmentResource;
import org.camunda.bpm.engine.rest.sub.task.TaskCommentResource;
import org.camunda.bpm.engine.rest.sub.task.TaskResource;
import org.camunda.bpm.engine.rest.sub.task.impl.LocalTaskVariablesResource;
import org.camunda.bpm.engine.rest.sub.task.impl.TaskAttachmentResourceImpl;
import org.camunda.bpm.engine.rest.sub.task.impl.TaskCommentResourceImpl;
import org.camunda.bpm.engine.rest.util.ApplicationContextPathUtil;
import org.camunda.bpm.engine.rest.util.DtoUtil;
import org.camunda.bpm.engine.task.IdentityLink;
import org.camunda.bpm.engine.task.Task;

public class TaskResourceImpl
implements TaskResource {
    private ProcessEngine engine;
    private String taskId;
    private String rootResourcePath;

    public TaskResourceImpl(ProcessEngine engine, String taskId, String rootResourcePath) {
        this.engine = engine;
        this.taskId = taskId;
        this.rootResourcePath = rootResourcePath;
    }

    public void claim(UserIdDto dto) {
        TaskService taskService = this.engine.getTaskService();
        taskService.claim(this.taskId, dto.getUserId());
    }

    public void unclaim() {
        this.engine.getTaskService().setAssignee(this.taskId, null);
    }

    public void complete(CompleteTaskDto dto) {
        TaskService taskService = this.engine.getTaskService();
        try {
            Map variables = DtoUtil.toMap((Map)dto.getVariables());
            taskService.complete(this.taskId, variables);
        }
        catch (NumberFormatException e) {
            String errorMessage = String.format("Cannot complete task %s due to number format exception: %s", this.taskId, e.getMessage());
            throw new RestException(Response.Status.BAD_REQUEST, (Exception)e, errorMessage);
        }
        catch (ParseException e) {
            String errorMessage = String.format("Cannot complete task %s due to parse exception: %s", this.taskId, e.getMessage());
            throw new RestException(Response.Status.BAD_REQUEST, (Exception)e, errorMessage);
        }
        catch (IllegalArgumentException e) {
            String errorMessage = String.format("Cannot complete task %s: %s", this.taskId, e.getMessage());
            throw new RestException(Response.Status.BAD_REQUEST, errorMessage);
        }
        catch (ProcessEngineException e) {
            String errorMessage = String.format("Cannot complete task %s: %s", this.taskId, e.getMessage());
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), errorMessage);
        }
    }

    public void submit(CompleteTaskDto dto) {
        FormService formService = this.engine.getFormService();
        try {
            Map variables = DtoUtil.toMap((Map)dto.getVariables());
            formService.submitTaskForm(this.taskId, variables);
        }
        catch (NumberFormatException e) {
            String errorMessage = String.format("Cannot submit task form %s due to number format exception: %s", this.taskId, e.getMessage());
            throw new RestException(Response.Status.BAD_REQUEST, (Exception)e, errorMessage);
        }
        catch (ParseException e) {
            String errorMessage = String.format("Cannot submit task form %s due to parse exception: %s", this.taskId, e.getMessage());
            throw new RestException(Response.Status.BAD_REQUEST, (Exception)e, errorMessage);
        }
        catch (IllegalArgumentException e) {
            String errorMessage = String.format("Cannot submit task form %s: %s", this.taskId, e.getMessage());
            throw new RestException(Response.Status.BAD_REQUEST, errorMessage);
        }
        catch (ProcessEngineException e) {
            String errorMessage = String.format("Cannot submit task form %s: %s", this.taskId, e.getMessage());
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), errorMessage);
        }
    }

    public void delegate(UserIdDto delegatedUser) {
        this.engine.getTaskService().delegateTask(this.taskId, delegatedUser.getUserId());
    }

    public TaskDto getTask() {
        Task task = this.getTaskById(this.taskId);
        if (task == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "No matching task with id " + this.taskId);
        }
        return TaskDto.fromTask((Task)task);
    }

    public FormDto getForm() {
        String processDefinitionId;
        TaskFormData formData;
        FormService formService = this.engine.getFormService();
        Task task = this.getTaskById(this.taskId);
        try {
            formData = formService.getTaskFormData(this.taskId);
        }
        catch (ProcessEngineException e) {
            throw new RestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), "Cannot get form for task " + this.taskId);
        }
        FormDto dto = FormDto.fromFormData((FormData)formData);
        if ((dto.getKey() == null || dto.getKey().isEmpty()) && formData.getFormFields() != null && !formData.getFormFields().isEmpty()) {
            dto.setKey("embedded:engine://engine/:engine/task/" + this.taskId + "/rendered-form");
        }
        if ((processDefinitionId = task.getProcessDefinitionId()) != null) {
            dto.setContextPath(ApplicationContextPathUtil.getApplicationPath((ProcessEngine)this.engine, (String)task.getProcessDefinitionId()));
        }
        return dto;
    }

    public String getRenderedForm() {
        FormService formService = this.engine.getFormService();
        Object renderedTaskForm = formService.getRenderedTaskForm(this.taskId);
        if (renderedTaskForm != null) {
            return renderedTaskForm.toString();
        }
        throw new InvalidRequestException(Response.Status.NOT_FOUND, "No matching rendered form for task with the id " + this.taskId + " found.");
    }

    public void resolve(CompleteTaskDto dto) {
        TaskService taskService = this.engine.getTaskService();
        try {
            Map variables = DtoUtil.toMap((Map)dto.getVariables());
            taskService.resolveTask(this.taskId, variables);
        }
        catch (NumberFormatException e) {
            String errorMessage = String.format("Cannot resolve task %s due to number format exception: %s", this.taskId, e.getMessage());
            throw new RestException(Response.Status.BAD_REQUEST, (Exception)e, errorMessage);
        }
        catch (ParseException e) {
            String errorMessage = String.format("Cannot resolve task %s due to parse exception: %s", this.taskId, e.getMessage());
            throw new RestException(Response.Status.BAD_REQUEST, (Exception)e, errorMessage);
        }
        catch (IllegalArgumentException e) {
            String errorMessage = String.format("Cannot resolve task %s: %s", this.taskId, e.getMessage());
            throw new RestException(Response.Status.BAD_REQUEST, errorMessage);
        }
    }

    protected Task getTaskById(String id) {
        return (Task)this.engine.getTaskService().createTaskQuery().taskId(id).singleResult();
    }

    public void setAssignee(UserIdDto dto) {
        TaskService taskService = this.engine.getTaskService();
        taskService.setAssignee(this.taskId, dto.getUserId());
    }

    public List<IdentityLinkDto> getIdentityLinks(String type) {
        TaskService taskService = this.engine.getTaskService();
        List identityLinks = taskService.getIdentityLinksForTask(this.taskId);
        ArrayList<IdentityLinkDto> result = new ArrayList<IdentityLinkDto>();
        for (IdentityLink link : identityLinks) {
            if (type != null && !type.equals(link.getType())) continue;
            result.add(IdentityLinkDto.fromIdentityLink((IdentityLink)link));
        }
        return result;
    }

    public void addIdentityLink(IdentityLinkDto identityLink) {
        TaskService taskService = this.engine.getTaskService();
        identityLink.validate();
        if (identityLink.getUserId() != null) {
            taskService.addUserIdentityLink(this.taskId, identityLink.getUserId(), identityLink.getType());
        } else if (identityLink.getGroupId() != null) {
            taskService.addGroupIdentityLink(this.taskId, identityLink.getGroupId(), identityLink.getType());
        }
    }

    public void deleteIdentityLink(IdentityLinkDto identityLink) {
        TaskService taskService = this.engine.getTaskService();
        identityLink.validate();
        if (identityLink.getUserId() != null) {
            taskService.deleteUserIdentityLink(this.taskId, identityLink.getUserId(), identityLink.getType());
        } else if (identityLink.getGroupId() != null) {
            taskService.deleteGroupIdentityLink(this.taskId, identityLink.getGroupId(), identityLink.getType());
        }
    }

    public TaskCommentResource getTaskCommentResource() {
        return new TaskCommentResourceImpl(this.engine, this.taskId, this.rootResourcePath);
    }

    public TaskAttachmentResource getAttachmentResource() {
        return new TaskAttachmentResourceImpl(this.engine, this.taskId, this.rootResourcePath);
    }

    public VariableResource getLocalVariables() {
        return new LocalTaskVariablesResource(this.engine, this.taskId);
    }
}

