/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.rest.dto.runtime.VariableValueDto;

public class DtoUtil {
    public static Map<String, Object> toMap(Map<String, VariableValueDto> variables) throws ParseException {
        if (variables == null) {
            return null;
        }
        HashMap<String, Object> variablesMap = new HashMap<String, Object>();
        for (Map.Entry<String, VariableValueDto> variable : variables.entrySet()) {
            String type = variable.getValue().getType();
            Object value = variable.getValue().getValue();
            if (type != null && !type.equals("") && value != null) {
                if (type.equalsIgnoreCase("boolean")) {
                    variablesMap.put(variable.getKey(), Boolean.valueOf(value.toString()));
                    continue;
                }
                if (type.equalsIgnoreCase("string")) {
                    variablesMap.put(variable.getKey(), String.valueOf(value));
                    continue;
                }
                if (type.equalsIgnoreCase("integer")) {
                    variablesMap.put(variable.getKey(), Integer.valueOf(value.toString()));
                    continue;
                }
                if (type.equalsIgnoreCase("short")) {
                    variablesMap.put(variable.getKey(), Short.valueOf(value.toString()));
                    continue;
                }
                if (type.equalsIgnoreCase("long")) {
                    variablesMap.put(variable.getKey(), Long.valueOf(value.toString()));
                    continue;
                }
                if (type.equalsIgnoreCase("double")) {
                    variablesMap.put(variable.getKey(), Double.valueOf(value.toString()));
                    continue;
                }
                if (type.equalsIgnoreCase("date")) {
                    SimpleDateFormat pattern = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                    Date date = pattern.parse(String.valueOf(value));
                    variablesMap.put(variable.getKey(), date);
                    continue;
                }
                throw new IllegalArgumentException("The variable type '" + type + "' is not supported.");
            }
            variablesMap.put(variable.getKey(), value);
        }
        return variablesMap;
    }
}

