/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.history;

import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricDetailVariableInstanceUpdateEntity;
import org.camunda.bpm.engine.rest.dto.history.HistoricDetailDto;
import org.camunda.bpm.engine.rest.dto.runtime.SerializedObjectDto;

public class HistoricVariableUpdateDto
extends HistoricDetailDto {
    protected String variableName;
    protected String variableTypeName;
    protected Object value;
    protected int revision;
    protected String errorMessage;

    public String getVariableName() {
        return this.variableName;
    }

    public String getVariableTypeName() {
        return this.variableTypeName;
    }

    public Object getValue() {
        return this.value;
    }

    public int getRevision() {
        return this.revision;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static HistoricVariableUpdateDto fromHistoricVariableUpdate(HistoricVariableUpdate historicVariableUpdate) {
        HistoricDetailVariableInstanceUpdateEntity entity = (HistoricDetailVariableInstanceUpdateEntity)historicVariableUpdate;
        HistoricVariableUpdateDto dto = new HistoricVariableUpdateDto();
        dto.revision = entity.getRevision();
        dto.variableName = entity.getVariableName();
        dto.variableTypeName = entity.getVariableTypeName();
        if ("serializable".equals(entity.getVariableType().getTypeName())) {
            if (entity.getValue() != null) {
                dto.value = new SerializedObjectDto(entity.getValue());
            }
        } else {
            dto.value = entity.getValue();
        }
        dto.variableTypeName = entity.getVariableType().getTypeNameForValue(entity.getValue());
        dto.errorMessage = entity.getErrorMessage();
        return dto;
    }
}

