/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.history;

import java.util.Date;
import javax.ws.rs.core.MultivaluedMap;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.converter.DateConverter;

public class UserOperationLogQueryDto
extends AbstractQueryDto<UserOperationLogQuery> {
    public static final String TIMESTAMP = "timestamp";
    private String processDefinitionId;
    private String processInstanceId;
    private String executionId;
    private String taskId;
    private String userId;
    private String operationId;
    private String operationType;
    private String entityType;
    private String property;
    private Date afterTimestamp;
    private Date beforeTimestamp;

    public UserOperationLogQueryDto(MultivaluedMap<String, String> queryParameters) {
        super(queryParameters);
    }

    protected boolean isValidSortByValue(String value) {
        return TIMESTAMP.equals(value);
    }

    protected UserOperationLogQuery createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createUserOperationLogQuery();
    }

    protected void applyFilters(UserOperationLogQuery query) {
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.executionId != null) {
            query.executionId(this.executionId);
        }
        if (this.taskId != null) {
            query.taskId(this.taskId);
        }
        if (this.userId != null) {
            query.userId(this.userId);
        }
        if (this.operationId != null) {
            query.operationId(this.operationId);
        }
        if (this.operationType != null) {
            query.operationType(this.operationType);
        }
        if (this.entityType != null) {
            query.entityType(this.entityType);
        }
        if (this.property != null) {
            query.property(this.property);
        }
        if (this.afterTimestamp != null) {
            query.afterTimestamp(this.afterTimestamp);
        }
        if (this.beforeTimestamp != null) {
            query.beforeTimestamp(this.beforeTimestamp);
        }
    }

    protected void applySortingOptions(UserOperationLogQuery query) {
        if (TIMESTAMP.equals(this.sortBy)) {
            query.orderByTimestamp();
        }
        if ("asc".equals(this.sortOrder)) {
            query.asc();
        }
        if ("desc".equals(this.sortOrder)) {
            query.desc();
        }
    }

    @CamundaQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @CamundaQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @CamundaQueryParam(value="executionId")
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @CamundaQueryParam(value="taskId")
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @CamundaQueryParam(value="userId")
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @CamundaQueryParam(value="operationId")
    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    @CamundaQueryParam(value="operationType")
    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    @CamundaQueryParam(value="entityType")
    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    @CamundaQueryParam(value="property")
    public void setProperty(String property) {
        this.property = property;
    }

    @CamundaQueryParam(value="afterTimestamp", converter=DateConverter.class)
    public void setAfterTimestamp(Date after) {
        this.afterTimestamp = after;
    }

    @CamundaQueryParam(value="beforeTimestamp", converter=DateConverter.class)
    public void setBeforeTimestamp(Date before) {
        this.beforeTimestamp = before;
    }
}

