/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.rest.JobRestService;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.runtime.JobDto;
import org.camunda.bpm.engine.rest.dto.runtime.JobQueryDto;
import org.camunda.bpm.engine.rest.dto.runtime.JobSuspensionStateDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.camunda.bpm.engine.rest.sub.runtime.JobResource;
import org.camunda.bpm.engine.rest.sub.runtime.impl.JobResourceImpl;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;

public class JobRestServiceImpl
extends AbstractRestProcessEngineAware
implements JobRestService {
    public JobRestServiceImpl() {
    }

    public JobRestServiceImpl(String engineName) {
        super(engineName);
    }

    public JobResource getJob(String jobId) {
        return new JobResourceImpl(this.getProcessEngine(), jobId);
    }

    public List<JobDto> getJobs(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        JobQueryDto queryDto = new JobQueryDto(uriInfo.getQueryParameters());
        return this.queryJobs(queryDto, firstResult, maxResults);
    }

    public List<JobDto> queryJobs(JobQueryDto queryDto, Integer firstResult, Integer maxResults) {
        ProcessEngine engine = this.getProcessEngine();
        JobQuery query = (JobQuery)queryDto.toQuery(engine);
        List matchingJobs = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        ArrayList<JobDto> jobResults = new ArrayList<JobDto>();
        for (Job job : matchingJobs) {
            JobDto resultJob = JobDto.fromJob((Job)job);
            jobResults.add(resultJob);
        }
        return jobResults;
    }

    public CountResultDto getJobsCount(@Context UriInfo uriInfo) {
        JobQueryDto queryDto = new JobQueryDto(uriInfo.getQueryParameters());
        return this.queryJobsCount(queryDto);
    }

    public CountResultDto queryJobsCount(JobQueryDto queryDto) {
        ProcessEngine engine = this.getProcessEngine();
        JobQuery query = (JobQuery)queryDto.toQuery(engine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }

    private List<Job> executePaginatedQuery(JobQuery query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }

    public void updateSuspensionState(JobSuspensionStateDto dto) {
        if (dto.getJobId() != null) {
            String message = "Either jobDefinitionId, processInstanceId, processDefinitionId or processDefinitionKey can be set to update the suspension state.";
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, message);
        }
        dto.updateSuspensionState(this.getProcessEngine());
    }
}

