/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.security.auth;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.rest.dto.ExceptionDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.security.auth.AuthenticationProvider;
import org.camunda.bpm.engine.rest.security.auth.AuthenticationResult;
import org.camunda.bpm.engine.rest.util.EngineUtil;
import org.codehaus.jackson.map.ObjectMapper;

public class ProcessEngineAuthenticationFilter
implements Filter {
    protected static final Pattern[] WHITE_LISTED_URL_PATTERNS = new Pattern[]{Pattern.compile("^/engine/?")};
    protected static final Pattern ENGINE_REQUEST_URL_PATTERN = Pattern.compile("^/engine/(.*?)(/|$)");
    protected static final String DEFAULT_ENGINE_NAME = "default";
    public static final String AUTHENTICATION_PROVIDER_PARAM = "authentication-provider";
    public static final String SERVLET_PATH_PREFIX = "rest-url-pattern-prefix";
    protected AuthenticationProvider authenticationProvider;
    protected String servletPathPrefix;

    public void init(FilterConfig filterConfig) throws ServletException {
        String authenticationProviderClassName = filterConfig.getInitParameter(AUTHENTICATION_PROVIDER_PARAM);
        if (authenticationProviderClassName == null) {
            throw new ServletException("Cannot instantiate authentication filter: no authentication provider set. init-param authentication-provider missing");
        }
        try {
            Class<?> authenticationProviderClass = Class.forName(authenticationProviderClassName);
            this.authenticationProvider = (AuthenticationProvider)authenticationProviderClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            new ServletException("Cannot instantiate authentication filter: authentication provider not found", (Throwable)e);
        }
        catch (InstantiationException e) {
            new ServletException("Cannot instantiate authentication filter: cannot instantiate authentication provider", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            new ServletException("Cannot instantiate authentication filter: constructor not accessible", (Throwable)e);
        }
        catch (ClassCastException e) {
            new ServletException("Cannot instantiate authentication filter: authentication provider does not implement interface " + AuthenticationProvider.class.getName(), (Throwable)e);
        }
        this.servletPathPrefix = filterConfig.getInitParameter(SERVLET_PATH_PREFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String requestUrl;
        boolean requiresEngineAuthentication;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String servletPath = this.servletPathPrefix;
        if (servletPath == null) {
            servletPath = req.getServletPath();
        }
        if (!(requiresEngineAuthentication = this.requiresEngineAuthentication(requestUrl = req.getRequestURI().substring(req.getContextPath().length() + servletPath.length())))) {
            chain.doFilter(request, response);
            return;
        }
        String engineName = this.extractEngineName(requestUrl);
        ProcessEngine engine = this.getAddressedEngine(engineName);
        if (engine == null) {
            resp.setStatus(Response.Status.NOT_FOUND.getStatusCode());
            ExceptionDto exceptionDto = new ExceptionDto();
            exceptionDto.setType(InvalidRequestException.class.getSimpleName());
            exceptionDto.setMessage("Process engine " + engineName + " not available");
            ObjectMapper objectMapper = new ObjectMapper();
            resp.setContentType("application/json");
            objectMapper.writer().writeValue((Writer)resp.getWriter(), (Object)exceptionDto);
            resp.getWriter().flush();
            return;
        }
        AuthenticationResult authenticationResult = this.authenticationProvider.extractAuthenticatedUser(req, engine);
        if (authenticationResult.isAuthenticated()) {
            try {
                this.setAuthenticatedUser(engine, authenticationResult.getAuthenticatedUser());
                chain.doFilter(request, response);
            }
            finally {
                this.clearAuthentication(engine);
            }
        } else {
            resp.setStatus(Response.Status.UNAUTHORIZED.getStatusCode());
            this.authenticationProvider.augmentResponseByAuthenticationChallenge(resp, engine);
        }
    }

    public void destroy() {
    }

    protected void setAuthenticatedUser(ProcessEngine engine, String userId) {
        List groupList = engine.getIdentityService().createGroupQuery().groupMember(userId).list();
        ArrayList<String> groupIds = new ArrayList<String>();
        for (Group group : groupList) {
            groupIds.add(group.getId());
        }
        engine.getIdentityService().setAuthentication(userId, groupIds);
    }

    protected void clearAuthentication(ProcessEngine engine) {
        engine.getIdentityService().clearAuthentication();
    }

    protected boolean requiresEngineAuthentication(String requestUrl) {
        for (Pattern whiteListedUrlPattern : WHITE_LISTED_URL_PATTERNS) {
            Matcher matcher = whiteListedUrlPattern.matcher(requestUrl);
            if (!matcher.matches()) continue;
            return false;
        }
        return true;
    }

    protected String extractEngineName(String requestUrl) {
        Matcher matcher = ENGINE_REQUEST_URL_PATTERN.matcher(requestUrl);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return DEFAULT_ENGINE_NAME;
    }

    protected ProcessEngine getAddressedEngine(String engineName) {
        return EngineUtil.lookupProcessEngine((String)engineName);
    }
}

