/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.history.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricDetailQuery;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.rest.dto.history.HistoricDetailDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.sub.history.HistoricDetailResource;

public class HistoricDetailResourceImpl
implements HistoricDetailResource {
    protected String detailId;
    protected ProcessEngine engine;

    public HistoricDetailResourceImpl(String detailId, ProcessEngine engine) {
        this.detailId = detailId;
        this.engine = engine;
    }

    public HistoricDetailDto getDetail() {
        HistoricDetail detail = (HistoricDetail)this.baseQuery().disableBinaryFetching().singleResult();
        if (detail != null) {
            return HistoricDetailDto.fromHistoricDetail((HistoricDetail)detail);
        }
        throw new InvalidRequestException(Response.Status.NOT_FOUND, "Historic detail with Id '" + this.detailId + "' does not exist.");
    }

    public InputStream getBinaryVariable() {
        HistoricDetail variableInstance = (HistoricDetail)this.baseQuery().singleResult();
        if (variableInstance == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Historic detail with Id '" + this.detailId + "' does not exist.");
        }
        if (!(variableInstance instanceof HistoricVariableUpdate)) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Historic detail with Id '" + this.detailId + "' is not a variable update.");
        }
        Object value = ((HistoricVariableUpdate)variableInstance).getValue();
        if (value instanceof byte[]) {
            return new ByteArrayInputStream((byte[])value);
        }
        throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Historic detail with Id '" + this.detailId + "' is not a binary variable.");
    }

    protected HistoricDetailQuery baseQuery() {
        return this.engine.getHistoryService().createHistoricDetailQuery().detailId(this.detailId);
    }
}

