/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.runtime.impl;

import java.text.ParseException;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.rest.dto.runtime.ExecutionDto;
import org.camunda.bpm.engine.rest.dto.runtime.ExecutionTriggerDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.sub.VariableResource;
import org.camunda.bpm.engine.rest.sub.runtime.EventSubscriptionResource;
import org.camunda.bpm.engine.rest.sub.runtime.ExecutionResource;
import org.camunda.bpm.engine.rest.sub.runtime.impl.LocalExecutionVariablesResource;
import org.camunda.bpm.engine.rest.sub.runtime.impl.MessageEventSubscriptionResource;
import org.camunda.bpm.engine.rest.util.DtoUtil;
import org.camunda.bpm.engine.runtime.Execution;

public class ExecutionResourceImpl
implements ExecutionResource {
    private ProcessEngine engine;
    private String executionId;

    public ExecutionResourceImpl(ProcessEngine engine, String executionId) {
        this.engine = engine;
        this.executionId = executionId;
    }

    public ExecutionDto getExecution() {
        RuntimeService runtimeService = this.engine.getRuntimeService();
        Execution execution = (Execution)runtimeService.createExecutionQuery().executionId(this.executionId).singleResult();
        if (execution == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Execution with id " + this.executionId + " does not exist");
        }
        return ExecutionDto.fromExecution((Execution)execution);
    }

    public void signalExecution(ExecutionTriggerDto triggerDto) {
        RuntimeService runtimeService = this.engine.getRuntimeService();
        try {
            Map variables = DtoUtil.toMap((Map)triggerDto.getVariables());
            runtimeService.signal(this.executionId, variables);
        }
        catch (ProcessEngineException e) {
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), "Cannot signal execution " + this.executionId + ": " + e.getMessage());
        }
        catch (NumberFormatException e) {
            String errorMessage = String.format("Cannot signal execution %s due to number format exception: %s", this.executionId, e.getMessage());
            throw new RestException(Response.Status.BAD_REQUEST, (Exception)e, errorMessage);
        }
        catch (ParseException e) {
            String errorMessage = String.format("Cannot signal execution %s due to parse exception: %s", this.executionId, e.getMessage());
            throw new RestException(Response.Status.BAD_REQUEST, (Exception)e, errorMessage);
        }
        catch (IllegalArgumentException e) {
            String errorMessage = String.format("Cannot signal execution %s: %s", this.executionId, e.getMessage());
            throw new RestException(Response.Status.BAD_REQUEST, errorMessage);
        }
    }

    public VariableResource getLocalVariables() {
        return new LocalExecutionVariablesResource(this.engine, this.executionId);
    }

    public EventSubscriptionResource getMessageEventSubscription(String messageName) {
        return new MessageEventSubscriptionResource(this.engine, this.executionId, messageName);
    }
}

