/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.VariableQueryParameterDto;
import org.camunda.bpm.engine.rest.dto.converter.BooleanConverter;
import org.camunda.bpm.engine.rest.dto.converter.StringSetConverter;
import org.camunda.bpm.engine.rest.dto.converter.VariableListConverter;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;

public class ProcessInstanceQueryDto
extends AbstractQueryDto<ProcessInstanceQuery> {
    private static final String SORT_BY_INSTANCE_ID_VALUE = "instanceId";
    private static final String SORT_BY_DEFINITION_KEY_VALUE = "definitionKey";
    private static final String SORT_BY_DEFINITION_ID_VALUE = "definitionId";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList();
    private String processDefinitionKey;
    private String businessKey;
    private String caseInstanceId;
    private String processDefinitionId;
    private String superProcessInstance;
    private String subProcessInstance;
    private Boolean active;
    private Boolean suspended;
    private Set<String> processInstanceIds;
    private String incidentId;
    private String incidentType;
    private String incidentMessage;
    private String incidentMessageLike;
    private List<VariableQueryParameterDto> variables;

    public ProcessInstanceQueryDto() {
    }

    public ProcessInstanceQueryDto(MultivaluedMap<String, String> queryParameters) {
        super(queryParameters);
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @CamundaQueryParam(value="processInstanceIds", converter=StringSetConverter.class)
    public void setProcessInstanceIds(Set<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
    }

    @CamundaQueryParam(value="processDefinitionKey")
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @CamundaQueryParam(value="businessKey")
    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    @CamundaQueryParam(value="caseInstanceId")
    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @CamundaQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @CamundaQueryParam(value="superProcessInstance")
    public void setSuperProcessInstance(String superProcessInstance) {
        this.superProcessInstance = superProcessInstance;
    }

    @CamundaQueryParam(value="subProcessInstance")
    public void setSubProcessInstance(String subProcessInstance) {
        this.subProcessInstance = subProcessInstance;
    }

    @CamundaQueryParam(value="active", converter=BooleanConverter.class)
    public void setActive(Boolean active) {
        this.active = active;
    }

    @CamundaQueryParam(value="suspended", converter=BooleanConverter.class)
    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    @CamundaQueryParam(value="variables", converter=VariableListConverter.class)
    public void setVariables(List<VariableQueryParameterDto> variables) {
        this.variables = variables;
    }

    @CamundaQueryParam(value="incidentId")
    public void setIncidentId(String incidentId) {
        this.incidentId = incidentId;
    }

    @CamundaQueryParam(value="incidentType")
    public void setIncidentType(String incidentType) {
        this.incidentType = incidentType;
    }

    @CamundaQueryParam(value="incidentMessage")
    public void setIncidentMessage(String incidentMessage) {
        this.incidentMessage = incidentMessage;
    }

    @CamundaQueryParam(value="incidentMessageLike")
    public void setIncidentMessageLike(String incidentMessageLike) {
        this.incidentMessageLike = incidentMessageLike;
    }

    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    protected ProcessInstanceQuery createNewQuery(ProcessEngine engine) {
        return engine.getRuntimeService().createProcessInstanceQuery();
    }

    protected void applyFilters(ProcessInstanceQuery query) {
        if (this.processInstanceIds != null) {
            query.processInstanceIds(this.processInstanceIds);
        }
        if (this.processDefinitionKey != null) {
            query.processDefinitionKey(this.processDefinitionKey);
        }
        if (this.businessKey != null) {
            query.processInstanceBusinessKey(this.businessKey);
        }
        if (this.caseInstanceId != null) {
            query.caseInstanceId(this.caseInstanceId);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.superProcessInstance != null) {
            query.superProcessInstanceId(this.superProcessInstance);
        }
        if (this.subProcessInstance != null) {
            query.subProcessInstanceId(this.subProcessInstance);
        }
        if (this.active != null && this.active.booleanValue()) {
            query.active();
        }
        if (this.suspended != null && this.suspended.booleanValue()) {
            query.suspended();
        }
        if (this.incidentId != null) {
            query.incidentId(this.incidentId);
        }
        if (this.incidentType != null) {
            query.incidentType(this.incidentType);
        }
        if (this.incidentMessage != null) {
            query.incidentMessage(this.incidentMessage);
        }
        if (this.incidentMessageLike != null) {
            query.incidentMessageLike(this.incidentMessageLike);
        }
        if (this.variables != null) {
            for (VariableQueryParameterDto variableQueryParam : this.variables) {
                String variableName = variableQueryParam.getName();
                String op = variableQueryParam.getOperator();
                Object variableValue = variableQueryParam.getValue();
                if (op.equals("eq")) {
                    query.variableValueEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("gt")) {
                    query.variableValueGreaterThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("gteq")) {
                    query.variableValueGreaterThanOrEqual(variableName, variableValue);
                    continue;
                }
                if (op.equals("lt")) {
                    query.variableValueLessThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("lteq")) {
                    query.variableValueLessThanOrEqual(variableName, variableValue);
                    continue;
                }
                if (op.equals("neq")) {
                    query.variableValueNotEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("like")) {
                    query.variableValueLike(variableName, String.valueOf(variableValue));
                    continue;
                }
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Invalid variable comparator specified: " + op);
            }
        }
    }

    protected void applySortingOptions(ProcessInstanceQuery query) {
        if (this.sortBy != null) {
            if (this.sortBy.equals(SORT_BY_INSTANCE_ID_VALUE)) {
                query.orderByProcessInstanceId();
            } else if (this.sortBy.equals(SORT_BY_DEFINITION_KEY_VALUE)) {
                query.orderByProcessDefinitionKey();
            } else if (this.sortBy.equals(SORT_BY_DEFINITION_ID_VALUE)) {
                query.orderByProcessDefinitionId();
            }
        }
        if (this.sortOrder != null) {
            if (this.sortOrder.equals("asc")) {
                query.asc();
            } else if (this.sortOrder.equals("desc")) {
                query.desc();
            }
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_INSTANCE_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_DEFINITION_KEY_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_DEFINITION_ID_VALUE);
    }
}

