/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.CaseDefinitionQuery;
import org.camunda.bpm.engine.rest.CaseDefinitionRestService;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.repository.CaseDefinitionDto;
import org.camunda.bpm.engine.rest.dto.repository.CaseDefinitionQueryDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.camunda.bpm.engine.rest.sub.repository.CaseDefinitionResource;
import org.camunda.bpm.engine.rest.sub.repository.impl.CaseDefinitionResourceImpl;

public class CaseDefinitionRestServiceImpl
extends AbstractRestProcessEngineAware
implements CaseDefinitionRestService {
    public CaseDefinitionRestServiceImpl() {
    }

    public CaseDefinitionRestServiceImpl(String engineName) {
        super(engineName);
    }

    public CaseDefinitionResource getCaseDefinitionByKey(String caseDefinitionKey) {
        if (caseDefinitionKey == null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Query parameter 'caseDefinitionKey' cannot be null");
        }
        ProcessEngine engine = this.getProcessEngine();
        RepositoryService repositoryService = engine.getRepositoryService();
        CaseDefinitionQuery query = repositoryService.createCaseDefinitionQuery();
        query.caseDefinitionKey(caseDefinitionKey).latestVersion();
        CaseDefinition caseDefinition = (CaseDefinition)query.singleResult();
        if (caseDefinition == null) {
            String errorMessage = String.format("No matching case definition with key: %s ", caseDefinitionKey);
            throw new RestException(Response.Status.NOT_FOUND, errorMessage);
        }
        return this.getCaseDefinitionById(caseDefinition.getId());
    }

    public CaseDefinitionResource getCaseDefinitionById(String caseDefinitionId) {
        return new CaseDefinitionResourceImpl(this.getProcessEngine(), caseDefinitionId, this.relativeRootResourcePath);
    }

    public List<CaseDefinitionDto> getCaseDefinitions(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        CaseDefinitionQueryDto queryDto = new CaseDefinitionQueryDto(uriInfo.getQueryParameters());
        ArrayList<CaseDefinitionDto> definitions = new ArrayList<CaseDefinitionDto>();
        ProcessEngine engine = this.getProcessEngine();
        CaseDefinitionQuery query = (CaseDefinitionQuery)queryDto.toQuery(engine);
        List matchingDefinitions = null;
        matchingDefinitions = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        for (CaseDefinition definition : matchingDefinitions) {
            CaseDefinitionDto def = CaseDefinitionDto.fromCaseDefinition((CaseDefinition)definition);
            definitions.add(def);
        }
        return definitions;
    }

    private List<CaseDefinition> executePaginatedQuery(CaseDefinitionQuery query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }

    public CountResultDto getCaseDefinitionsCount(UriInfo uriInfo) {
        CaseDefinitionQueryDto queryDto = new CaseDefinitionQueryDto(uriInfo.getQueryParameters());
        ProcessEngine engine = this.getProcessEngine();
        CaseDefinitionQuery query = (CaseDefinitionQuery)queryDto.toQuery(engine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

