/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import java.net.URI;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.identity.UserQuery;
import org.camunda.bpm.engine.rest.UserRestService;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.ResourceOptionsDto;
import org.camunda.bpm.engine.rest.dto.identity.UserDto;
import org.camunda.bpm.engine.rest.dto.identity.UserProfileDto;
import org.camunda.bpm.engine.rest.dto.identity.UserQueryDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.impl.AbstractAuthorizedRestResource;
import org.camunda.bpm.engine.rest.sub.identity.UserResource;
import org.camunda.bpm.engine.rest.sub.identity.impl.UserResourceImpl;
import org.camunda.bpm.engine.rest.util.PathUtil;

public class UserRestServiceImpl
extends AbstractAuthorizedRestResource
implements UserRestService {
    public UserRestServiceImpl() {
        super((Resource)Resources.USER, "*");
    }

    public UserRestServiceImpl(String engineName) {
        super(engineName, (Resource)Resources.USER, "*");
    }

    public UserResource getUser(String id) {
        id = PathUtil.decodePathParam((String)id);
        return new UserResourceImpl(this.getProcessEngine().getName(), id, this.relativeRootResourcePath);
    }

    public List<UserProfileDto> queryUsers(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        UserQueryDto queryDto = new UserQueryDto(uriInfo.getQueryParameters());
        return this.queryUsers(queryDto, firstResult, maxResults);
    }

    public List<UserProfileDto> queryUsers(UserQueryDto queryDto, Integer firstResult, Integer maxResults) {
        UserQuery query = (UserQuery)queryDto.toQuery(this.getProcessEngine());
        List resultList = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        return UserProfileDto.fromUserList((List)resultList);
    }

    public CountResultDto getUserCount(UriInfo uriInfo) {
        UserQueryDto queryDto = new UserQueryDto(uriInfo.getQueryParameters());
        return this.getUserCount(queryDto);
    }

    protected CountResultDto getUserCount(UserQueryDto queryDto) {
        UserQuery query = (UserQuery)queryDto.toQuery(this.getProcessEngine());
        long count = query.count();
        return new CountResultDto(count);
    }

    public void createUser(UserDto userDto) {
        IdentityService identityService = this.getIdentityService();
        if (identityService.isReadOnly()) {
            throw new InvalidRequestException(Response.Status.FORBIDDEN, "Identity service implementation is read-only.");
        }
        UserProfileDto profile = userDto.getProfile();
        if (profile == null || profile.getId() == null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "request object must provide profile information with valid id.");
        }
        User newUser = identityService.newUser(profile.getId());
        profile.update(newUser);
        if (userDto.getCredentials() != null) {
            newUser.setPassword(userDto.getCredentials().getPassword());
        }
        identityService.saveUser(newUser);
    }

    public ResourceOptionsDto availableOperations(UriInfo context) {
        IdentityService identityService = this.getIdentityService();
        UriBuilder baseUriBuilder = context.getBaseUriBuilder().path(this.relativeRootResourcePath).path(UserRestService.class);
        ResourceOptionsDto resourceOptionsDto = new ResourceOptionsDto();
        URI baseUri = baseUriBuilder.build(new Object[0]);
        resourceOptionsDto.addReflexiveLink(baseUri, "GET", "list");
        URI countUri = baseUriBuilder.clone().path("/count").build(new Object[0]);
        resourceOptionsDto.addReflexiveLink(countUri, "GET", "count");
        if (!identityService.isReadOnly() && this.isAuthorized((Permission)Permissions.CREATE)) {
            URI createUri = baseUriBuilder.clone().path("/create").build(new Object[0]);
            resourceOptionsDto.addReflexiveLink(createUri, "POST", "create");
        }
        return resourceOptionsDto;
    }

    protected List<User> executePaginatedQuery(UserQuery query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }

    protected IdentityService getIdentityService() {
        return this.getProcessEngine().getIdentityService();
    }
}

