/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl.history;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.history.HistoricIncidentQuery;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricIncidentDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricIncidentQueryDto;
import org.camunda.bpm.engine.rest.history.HistoricIncidentRestService;

public class HistoricIncidentRestServiceImpl
implements HistoricIncidentRestService {
    protected ProcessEngine processEngine;

    public HistoricIncidentRestServiceImpl(ProcessEngine processEngine) {
        this.processEngine = processEngine;
    }

    public List<HistoricIncidentDto> getHistoricIncidents(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        HistoricIncidentQueryDto queryDto = new HistoricIncidentQueryDto(uriInfo.getQueryParameters());
        HistoricIncidentQuery query = (HistoricIncidentQuery)queryDto.toQuery(this.processEngine);
        List queryResult = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        ArrayList<HistoricIncidentDto> result = new ArrayList<HistoricIncidentDto>();
        for (HistoricIncident historicIncident : queryResult) {
            HistoricIncidentDto dto = HistoricIncidentDto.fromHistoricIncident((HistoricIncident)historicIncident);
            result.add(dto);
        }
        return result;
    }

    public CountResultDto getHistoricIncidentsCount(UriInfo uriInfo) {
        HistoricIncidentQueryDto queryDto = new HistoricIncidentQueryDto(uriInfo.getQueryParameters());
        HistoricIncidentQuery query = (HistoricIncidentQuery)queryDto.toQuery(this.processEngine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }

    private List<HistoricIncident> executePaginatedQuery(HistoricIncidentQuery query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }
}

