/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.runtime.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.rest.dto.runtime.VariableInstanceDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.sub.runtime.VariableInstanceResource;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;

public class VariableInstanceResourceImpl
implements VariableInstanceResource {
    protected String variableId;
    protected ProcessEngine engine;

    public VariableInstanceResourceImpl(String variableId, ProcessEngine engine) {
        this.variableId = variableId;
        this.engine = engine;
    }

    public VariableInstanceDto getVariable() {
        VariableInstance variableInstance = (VariableInstance)this.baseQuery().disableBinaryFetching().singleResult();
        if (variableInstance != null) {
            return VariableInstanceDto.fromVariableInstance((VariableInstance)variableInstance);
        }
        throw new InvalidRequestException(Response.Status.NOT_FOUND, "Variable instance with Id '" + this.variableId + "' does not exist.");
    }

    public InputStream getBinaryVariable() {
        VariableInstance variableInstance = (VariableInstance)this.baseQuery().singleResult();
        if (variableInstance != null) {
            Object value = variableInstance.getValue();
            if (value instanceof byte[]) {
                return new ByteArrayInputStream((byte[])value);
            }
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Variable instance with Id '" + this.variableId + "' is not a binary variable.");
        }
        throw new InvalidRequestException(Response.Status.NOT_FOUND, "Variable instance with Id '" + this.variableId + "' does not exist.");
    }

    protected VariableInstanceQuery baseQuery() {
        return this.engine.getRuntimeService().createVariableInstanceQuery().variableId(this.variableId);
    }
}

