/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.repository;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;

public class DeploymentQueryDto
extends AbstractQueryDto<DeploymentQuery> {
    private static final String SORT_BY_ID_VALUE = "id";
    private static final String SORT_BY_NAME_VALUE = "name";
    private static final String SORT_BY_DEPLOYMENT_TIME_VALUE = "deploymentTime";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList();
    private String id;
    private String name;
    private String nameLike;

    public DeploymentQueryDto() {
    }

    public DeploymentQueryDto(MultivaluedMap<String, String> queryParameters) {
        super(queryParameters);
    }

    @CamundaQueryParam(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @CamundaQueryParam(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @CamundaQueryParam(value="nameLike")
    public void setNameLike(String nameLike) {
        this.nameLike = nameLike;
    }

    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    protected DeploymentQuery createNewQuery(ProcessEngine engine) {
        return engine.getRepositoryService().createDeploymentQuery();
    }

    protected void applyFilters(DeploymentQuery query) {
        if (this.id != null) {
            query.deploymentId(this.id);
        }
        if (this.name != null) {
            query.deploymentName(this.name);
        }
        if (this.nameLike != null) {
            query.deploymentNameLike(this.nameLike);
        }
    }

    protected void applySortingOptions(DeploymentQuery query) {
        if (this.sortBy != null) {
            if (this.sortBy.equals(SORT_BY_ID_VALUE)) {
                query.orderByDeploymentId();
            } else if (this.sortBy.equals(SORT_BY_NAME_VALUE)) {
                query.orderByDeploymentName();
            } else if (this.sortBy.equals(SORT_BY_DEPLOYMENT_TIME_VALUE)) {
                query.orderByDeploymenTime();
            }
        }
        if (this.sortOrder != null) {
            if (this.sortOrder.equals("asc")) {
                query.asc();
            } else if (this.sortOrder.equals("desc")) {
                query.desc();
            }
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_NAME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_DEPLOYMENT_TIME_VALUE);
    }
}

