/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.hal;

import javax.ws.rs.core.UriBuilder;

public class HalRelation {
    protected String relName;
    protected UriBuilder uriTemplate;
    protected Class<?> resourceType;

    public static HalRelation build(String relName, Class<?> resourceType) {
        HalRelation relation = new HalRelation();
        relation.relName = relName;
        relation.uriTemplate = UriBuilder.fromResource(resourceType).path("{id}");
        relation.resourceType = resourceType;
        return relation;
    }

    public static HalRelation build(String relName, Class<?> resourceType, UriBuilder urlTemplate) {
        HalRelation relation = new HalRelation();
        relation.relName = relName;
        relation.uriTemplate = urlTemplate;
        relation.resourceType = resourceType;
        return relation;
    }

    public String getRelName() {
        return this.relName;
    }

    public UriBuilder getUriTemplate() {
        return this.uriTemplate;
    }

    public Class<?> getResourceType() {
        return this.resourceType;
    }
}

