/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.hal.processDefinition;

import javax.ws.rs.core.UriBuilder;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.rest.DeploymentRestService;
import org.camunda.bpm.engine.rest.ProcessDefinitionRestService;
import org.camunda.bpm.engine.rest.hal.HalRelation;
import org.camunda.bpm.engine.rest.hal.HalResource;
import org.camunda.bpm.engine.rest.sub.repository.DeploymentResourcesResource;
import org.camunda.bpm.engine.rest.util.ApplicationContextPathUtil;

public class HalProcessDefinition
extends HalResource<HalProcessDefinition> {
    public static final HalRelation REL_SELF = HalRelation.build((String)"self", ProcessDefinitionRestService.class);
    public static final HalRelation REL_DEPLOYMENT = HalRelation.build((String)"deployment", DeploymentRestService.class);
    public static final HalRelation REL_DEPLOYMENT_RESOURCE = HalRelation.build((String)"resource", DeploymentResourcesResource.class, (UriBuilder)UriBuilder.fromResource(DeploymentRestService.class).path("{deploymentId}").path("resources").path("{resourceId}"));
    protected String id;
    protected String key;
    protected String category;
    protected String description;
    protected String name;
    protected int version;
    protected String resource;
    protected String deploymentId;
    protected String diagram;
    protected boolean suspended;
    protected String contextPath;

    public static HalProcessDefinition fromProcessDefinition(ProcessDefinition processDefinition, ProcessEngine processEngine) {
        HalProcessDefinition halProcDef = new HalProcessDefinition();
        halProcDef.id = processDefinition.getId();
        halProcDef.key = processDefinition.getKey();
        halProcDef.category = processDefinition.getCategory();
        halProcDef.description = processDefinition.getDescription();
        halProcDef.name = processDefinition.getName();
        halProcDef.version = processDefinition.getVersion();
        halProcDef.resource = processDefinition.getResourceName();
        halProcDef.deploymentId = processDefinition.getDeploymentId();
        halProcDef.diagram = processDefinition.getDiagramResourceName();
        halProcDef.suspended = processDefinition.isSuspended();
        halProcDef.contextPath = ApplicationContextPathUtil.getApplicationPathForDeployment((ProcessEngine)processEngine, (String)processDefinition.getDeploymentId());
        halProcDef.linker.createLink(REL_SELF, new String[]{processDefinition.getId()});
        halProcDef.linker.createLink(REL_DEPLOYMENT, new String[]{processDefinition.getDeploymentId()});
        halProcDef.linker.createLink(REL_DEPLOYMENT_RESOURCE, new String[]{processDefinition.getDeploymentId(), processDefinition.getResourceName()});
        return halProcDef;
    }

    public String getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public int getVersion() {
        return this.version;
    }

    public String getResource() {
        return this.resource;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public String getDiagram() {
        return this.diagram;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public String getContextPath() {
        return this.contextPath;
    }
}

