/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.hal.task;

import java.util.Date;
import org.camunda.bpm.engine.rest.CaseDefinitionRestService;
import org.camunda.bpm.engine.rest.CaseExecutionRestService;
import org.camunda.bpm.engine.rest.CaseInstanceRestService;
import org.camunda.bpm.engine.rest.ExecutionRestService;
import org.camunda.bpm.engine.rest.ProcessDefinitionRestService;
import org.camunda.bpm.engine.rest.ProcessInstanceRestService;
import org.camunda.bpm.engine.rest.TaskRestService;
import org.camunda.bpm.engine.rest.UserRestService;
import org.camunda.bpm.engine.rest.hal.HalRelation;
import org.camunda.bpm.engine.rest.hal.HalResource;
import org.camunda.bpm.engine.task.DelegationState;
import org.camunda.bpm.engine.task.Task;

public class HalTask
extends HalResource<HalTask> {
    public static HalRelation REL_SELF = HalRelation.build((String)"self", TaskRestService.class);
    public static HalRelation REL_ASSIGNEE = HalRelation.build((String)"assignee", UserRestService.class);
    public static HalRelation REL_OWNER = HalRelation.build((String)"owner", UserRestService.class);
    public static HalRelation REL_EXECUTION = HalRelation.build((String)"execution", ExecutionRestService.class);
    public static HalRelation REL_PARENT_TASK = HalRelation.build((String)"parentTask", TaskRestService.class);
    public static HalRelation REL_PROCESS_DEFINITION = HalRelation.build((String)"processDefinition", ProcessDefinitionRestService.class);
    public static HalRelation REL_PROCESS_INSTANCE = HalRelation.build((String)"processInstance", ProcessInstanceRestService.class);
    public static HalRelation REL_CASE_INSTANCE = HalRelation.build((String)"caseInstance", CaseInstanceRestService.class);
    public static HalRelation REL_CASE_EXECUTION = HalRelation.build((String)"caseExecution", CaseExecutionRestService.class);
    public static HalRelation REL_CASE_DEFINITION = HalRelation.build((String)"caseDefinition", CaseDefinitionRestService.class);
    private String id;
    private String name;
    private String assignee;
    private Date created;
    private Date due;
    private Date followUp;
    private DelegationState delegationState;
    private String description;
    private String executionId;
    private String owner;
    private String parentTaskId;
    private int priority;
    private String processDefinitionId;
    private String processInstanceId;
    private String taskDefinitionKey;
    private String caseExecutionId;
    private String caseInstanceId;
    private String caseDefinitionId;
    private boolean suspended;
    private String formKey;

    public static HalTask fromTask(Task task) {
        HalTask dto = new HalTask();
        dto.id = task.getId();
        dto.name = task.getName();
        dto.assignee = task.getAssignee();
        dto.created = task.getCreateTime();
        dto.due = task.getDueDate();
        dto.followUp = task.getFollowUpDate();
        dto.delegationState = task.getDelegationState();
        dto.description = task.getDescription();
        dto.executionId = task.getExecutionId();
        dto.owner = task.getOwner();
        dto.parentTaskId = task.getParentTaskId();
        dto.priority = task.getPriority();
        dto.processDefinitionId = task.getProcessDefinitionId();
        dto.processInstanceId = task.getProcessInstanceId();
        dto.taskDefinitionKey = task.getTaskDefinitionKey();
        dto.caseDefinitionId = task.getCaseDefinitionId();
        dto.caseExecutionId = task.getCaseExecutionId();
        dto.caseInstanceId = task.getCaseInstanceId();
        dto.suspended = task.isSuspended();
        dto.formKey = task.getFormKey();
        dto.linker.createLink(REL_SELF, new String[]{task.getId()});
        dto.linker.createLink(REL_ASSIGNEE, new String[]{task.getAssignee()});
        dto.linker.createLink(REL_OWNER, new String[]{task.getOwner()});
        dto.linker.createLink(REL_EXECUTION, new String[]{task.getExecutionId()});
        dto.linker.createLink(REL_PARENT_TASK, new String[]{task.getParentTaskId()});
        dto.linker.createLink(REL_PROCESS_DEFINITION, new String[]{task.getProcessDefinitionId()});
        dto.linker.createLink(REL_PROCESS_INSTANCE, new String[]{task.getProcessInstanceId()});
        dto.linker.createLink(REL_CASE_INSTANCE, new String[]{task.getCaseInstanceId()});
        dto.linker.createLink(REL_CASE_EXECUTION, new String[]{task.getCaseExecutionId()});
        dto.linker.createLink(REL_CASE_DEFINITION, new String[]{task.getCaseDefinitionId()});
        return dto;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getDue() {
        return this.due;
    }

    public DelegationState getDelegationState() {
        return this.delegationState;
    }

    public String getDescription() {
        return this.description;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getParentTaskId() {
        return this.parentTaskId;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getTaskDefinitionKey() {
        return this.taskDefinitionKey;
    }

    public Date getFollowUp() {
        return this.followUp;
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public String getCaseExecutionId() {
        return this.caseExecutionId;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public String getFormKey() {
        return this.formKey;
    }
}

