/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.rest.DeploymentRestService;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.repository.DeploymentDto;
import org.camunda.bpm.engine.rest.dto.repository.DeploymentQueryDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.camunda.bpm.engine.rest.mapper.MultipartFormData;
import org.camunda.bpm.engine.rest.sub.repository.DeploymentResource;
import org.camunda.bpm.engine.rest.sub.repository.impl.DeploymentResourceImpl;

public class DeploymentRestServiceImpl
extends AbstractRestProcessEngineAware
implements DeploymentRestService {
    public static final String DEPLOYMENT_NAME = "deployment-name";
    public static final String ENABLE_DUPLICATE_FILTERING = "enable-duplicate-filtering";

    public DeploymentRestServiceImpl() {
    }

    public DeploymentRestServiceImpl(String engineName) {
        super(engineName);
    }

    public DeploymentResource getDeployment(String deploymentId) {
        return new DeploymentResourceImpl(this.getProcessEngine(), deploymentId);
    }

    public List<DeploymentDto> getDeployments(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        DeploymentQueryDto queryDto = new DeploymentQueryDto(uriInfo.getQueryParameters());
        ProcessEngine engine = this.getProcessEngine();
        DeploymentQuery query = (DeploymentQuery)queryDto.toQuery(engine);
        List matchingDeployments = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        ArrayList<DeploymentDto> deployments = new ArrayList<DeploymentDto>();
        for (Deployment deployment : matchingDeployments) {
            DeploymentDto def = DeploymentDto.fromDeployment((Deployment)deployment);
            deployments.add(def);
        }
        return deployments;
    }

    public DeploymentDto createDeployment(UriInfo uriInfo, MultipartFormData payload) {
        DeploymentBuilder deploymentBuilder = this.getProcessEngine().getRepositoryService().createDeployment();
        Set partNames = payload.getPartNames();
        for (String name : partNames) {
            MultipartFormData.FormPart part = payload.getNamedPart(name);
            if (DEPLOYMENT_NAME.equals(name)) {
                deploymentBuilder.name(part.getTextContent());
                continue;
            }
            if (ENABLE_DUPLICATE_FILTERING.equals(name)) {
                if (!Boolean.parseBoolean(part.getTextContent())) continue;
                deploymentBuilder.enableDuplicateFiltering();
                continue;
            }
            deploymentBuilder.addInputStream(part.getFileName(), (InputStream)new ByteArrayInputStream(part.getBinaryContent()));
        }
        if (!deploymentBuilder.getResourceNames().isEmpty()) {
            Deployment deployment = deploymentBuilder.deploy();
            DeploymentDto deploymentDto = DeploymentDto.fromDeployment((Deployment)deployment);
            URI uri = uriInfo.getBaseUriBuilder().path(this.relativeRootResourcePath).path(DeploymentRestService.class).path(deployment.getId()).build(new Object[0]);
            deploymentDto.addReflexiveLink(uri, "GET", "self");
            return deploymentDto;
        }
        throw new InvalidRequestException(Response.Status.BAD_REQUEST, "No deployment resources contained in the form upload.");
    }

    private List<Deployment> executePaginatedQuery(DeploymentQuery query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }

    public CountResultDto getDeploymentsCount(UriInfo uriInfo) {
        DeploymentQueryDto queryDto = new DeploymentQueryDto(uriInfo.getQueryParameters());
        ProcessEngine engine = this.getProcessEngine();
        DeploymentQuery query = (DeploymentQuery)queryDto.toQuery(engine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

