/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import java.text.ParseException;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.MismatchingMessageCorrelationException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.rest.MessageRestService;
import org.camunda.bpm.engine.rest.dto.message.CorrelationMessageDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.camunda.bpm.engine.rest.util.DtoUtil;
import org.camunda.bpm.engine.runtime.MessageCorrelationBuilder;

public class MessageRestServiceImpl
extends AbstractRestProcessEngineAware
implements MessageRestService {
    public MessageRestServiceImpl() {
    }

    public MessageRestServiceImpl(String engineName) {
        super(engineName);
    }

    public void deliverMessage(CorrelationMessageDto messageDto) {
        if (messageDto.getMessageName() == null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "No message name supplied");
        }
        RuntimeService runtimeService = this.processEngine.getRuntimeService();
        try {
            Map correlationKeys = DtoUtil.toMap((Map)messageDto.getCorrelationKeys());
            Map processVariables = DtoUtil.toMap((Map)messageDto.getProcessVariables());
            MessageCorrelationBuilder correlation = runtimeService.createMessageCorrelation(messageDto.getMessageName()).setVariables(processVariables).processInstanceBusinessKey(messageDto.getBusinessKey());
            if (correlationKeys != null && !correlationKeys.isEmpty()) {
                for (Map.Entry correlationKey : correlationKeys.entrySet()) {
                    String name = (String)correlationKey.getKey();
                    Object value = correlationKey.getValue();
                    correlation.processInstanceVariableEquals(name, value);
                }
            }
            if (!messageDto.isAll()) {
                correlation.correlate();
            } else {
                correlation.correlateAll();
            }
        }
        catch (MismatchingMessageCorrelationException e) {
            throw new RestException(Response.Status.BAD_REQUEST, (Exception)((Object)e));
        }
        catch (NumberFormatException e) {
            String errorMessage = String.format("Cannot deliver a message due to number format exception: %s", e.getMessage());
            throw new RestException(Response.Status.BAD_REQUEST, (Exception)e, errorMessage);
        }
        catch (ParseException e) {
            String errorMessage = String.format("Cannot deliver a message due to parse exception: %s", e.getMessage());
            throw new RestException(Response.Status.BAD_REQUEST, (Exception)e, errorMessage);
        }
        catch (IllegalArgumentException e) {
            String errorMessage = String.format("Cannot deliver a message: %s", e.getMessage());
            throw new RestException(Response.Status.BAD_REQUEST, errorMessage);
        }
    }
}

