/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.camunda.bpm.engine.rest.AuthorizationRestService;
import org.camunda.bpm.engine.rest.CaseDefinitionRestService;
import org.camunda.bpm.engine.rest.CaseExecutionRestService;
import org.camunda.bpm.engine.rest.CaseInstanceRestService;
import org.camunda.bpm.engine.rest.DeploymentRestService;
import org.camunda.bpm.engine.rest.ExecutionRestService;
import org.camunda.bpm.engine.rest.GroupRestService;
import org.camunda.bpm.engine.rest.IdentityRestService;
import org.camunda.bpm.engine.rest.IncidentRestService;
import org.camunda.bpm.engine.rest.JobDefinitionRestService;
import org.camunda.bpm.engine.rest.JobRestService;
import org.camunda.bpm.engine.rest.MessageRestService;
import org.camunda.bpm.engine.rest.ProcessDefinitionRestService;
import org.camunda.bpm.engine.rest.ProcessEngineRestService;
import org.camunda.bpm.engine.rest.ProcessInstanceRestService;
import org.camunda.bpm.engine.rest.TaskRestService;
import org.camunda.bpm.engine.rest.UserRestService;
import org.camunda.bpm.engine.rest.VariableInstanceRestService;
import org.camunda.bpm.engine.rest.dto.ProcessEngineDto;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.history.HistoryRestService;
import org.camunda.bpm.engine.rest.impl.AuthorizationRestServiceImpl;
import org.camunda.bpm.engine.rest.impl.CaseDefinitionRestServiceImpl;
import org.camunda.bpm.engine.rest.impl.CaseExecutionRestServiceImpl;
import org.camunda.bpm.engine.rest.impl.CaseInstanceRestServiceImpl;
import org.camunda.bpm.engine.rest.impl.DeploymentRestServiceImpl;
import org.camunda.bpm.engine.rest.impl.ExecutionRestServiceImpl;
import org.camunda.bpm.engine.rest.impl.GroupRestServiceImpl;
import org.camunda.bpm.engine.rest.impl.IdentityRestServiceImpl;
import org.camunda.bpm.engine.rest.impl.IncidentRestServiceImpl;
import org.camunda.bpm.engine.rest.impl.JobDefinitionRestServiceImpl;
import org.camunda.bpm.engine.rest.impl.JobRestServiceImpl;
import org.camunda.bpm.engine.rest.impl.MessageRestServiceImpl;
import org.camunda.bpm.engine.rest.impl.ProcessDefinitionRestServiceImpl;
import org.camunda.bpm.engine.rest.impl.ProcessInstanceRestServiceImpl;
import org.camunda.bpm.engine.rest.impl.TaskRestServiceImpl;
import org.camunda.bpm.engine.rest.impl.UserRestServiceImpl;
import org.camunda.bpm.engine.rest.impl.VariableInstanceRestServiceImpl;
import org.camunda.bpm.engine.rest.impl.history.HistoryRestServiceImpl;
import org.camunda.bpm.engine.rest.spi.ProcessEngineProvider;

public class ProcessEngineRestServiceImpl
implements ProcessEngineRestService {
    public ProcessDefinitionRestService getProcessDefinitionService(String engineName) {
        String rootResourcePath = this.getRelativeEngineUri(engineName).toASCIIString();
        ProcessDefinitionRestServiceImpl subResource = new ProcessDefinitionRestServiceImpl(engineName);
        subResource.setRelativeRootResourceUri(rootResourcePath);
        return subResource;
    }

    public ProcessInstanceRestService getProcessInstanceService(String engineName) {
        String rootResourcePath = this.getRelativeEngineUri(engineName).toASCIIString();
        ProcessInstanceRestServiceImpl subResource = new ProcessInstanceRestServiceImpl(engineName);
        subResource.setRelativeRootResourceUri(rootResourcePath);
        return subResource;
    }

    public ExecutionRestService getExecutionService(String engineName) {
        String rootResourcePath = this.getRelativeEngineUri(engineName).toASCIIString();
        ExecutionRestServiceImpl subResource = new ExecutionRestServiceImpl(engineName);
        subResource.setRelativeRootResourceUri(rootResourcePath);
        return subResource;
    }

    public TaskRestService getTaskRestService(String engineName) {
        String rootResourcePath = this.getRelativeEngineUri(engineName).toASCIIString();
        TaskRestServiceImpl subResource = new TaskRestServiceImpl(engineName);
        subResource.setRelativeRootResourceUri(rootResourcePath);
        return subResource;
    }

    public IdentityRestService getIdentityRestService(String engineName) {
        String rootResourcePath = this.getRelativeEngineUri(engineName).toASCIIString();
        IdentityRestServiceImpl subResource = new IdentityRestServiceImpl(engineName);
        subResource.setRelativeRootResourceUri(rootResourcePath);
        return subResource;
    }

    public MessageRestService getMessageRestService(String engineName) {
        String rootResourcePath = this.getRelativeEngineUri(engineName).toASCIIString();
        MessageRestServiceImpl subResource = new MessageRestServiceImpl(engineName);
        subResource.setRelativeRootResourceUri(rootResourcePath);
        return subResource;
    }

    public VariableInstanceRestService getVariableInstanceService(String engineName) {
        String rootResourcePath = this.getRelativeEngineUri(engineName).toASCIIString();
        VariableInstanceRestServiceImpl subResource = new VariableInstanceRestServiceImpl(engineName);
        subResource.setRelativeRootResourceUri(rootResourcePath);
        return subResource;
    }

    public JobDefinitionRestService getJobDefinitionRestService(String engineName) {
        String rootResourcePath = this.getRelativeEngineUri(engineName).toASCIIString();
        JobDefinitionRestServiceImpl subResource = new JobDefinitionRestServiceImpl(engineName);
        subResource.setRelativeRootResourceUri(rootResourcePath);
        return subResource;
    }

    public JobRestService getJobRestService(String engineName) {
        String rootResourcePath = this.getRelativeEngineUri(engineName).toASCIIString();
        JobRestServiceImpl subResource = new JobRestServiceImpl(engineName);
        subResource.setRelativeRootResourceUri(rootResourcePath);
        return subResource;
    }

    public GroupRestService getGroupRestService(String engineName) {
        String rootResourcePath = this.getRelativeEngineUri(engineName).toASCIIString();
        GroupRestServiceImpl subResource = new GroupRestServiceImpl(engineName);
        subResource.setRelativeRootResourceUri(rootResourcePath);
        return subResource;
    }

    public UserRestService getUserRestService(String engineName) {
        String rootResourcePath = this.getRelativeEngineUri(engineName).toASCIIString();
        UserRestServiceImpl subResource = new UserRestServiceImpl(engineName);
        subResource.setRelativeRootResourceUri(rootResourcePath);
        return subResource;
    }

    public AuthorizationRestService getAuthorizationRestService(String engineName) {
        String rootResourcePath = this.getRelativeEngineUri(engineName).toASCIIString();
        AuthorizationRestServiceImpl subResource = new AuthorizationRestServiceImpl(engineName);
        subResource.setRelativeRootResourceUri(rootResourcePath);
        return subResource;
    }

    public IncidentRestService getIncidentService(String engineName) {
        String rootResourcePath = this.getRelativeEngineUri(engineName).toASCIIString();
        IncidentRestServiceImpl subResource = new IncidentRestServiceImpl(engineName);
        subResource.setRelativeRootResourceUri(rootResourcePath);
        return subResource;
    }

    public HistoryRestService getHistoryRestService(String engineName) {
        String rootResourcePath = this.getRelativeEngineUri(engineName).toASCIIString();
        HistoryRestServiceImpl subResource = new HistoryRestServiceImpl(engineName);
        subResource.setRelativeRootResourceUri(rootResourcePath);
        return subResource;
    }

    public DeploymentRestService getDeploymentRestService(String engineName) {
        String rootResourcePath = this.getRelativeEngineUri(engineName).toASCIIString();
        DeploymentRestServiceImpl subResource = new DeploymentRestServiceImpl(engineName);
        subResource.setRelativeRootResourceUri(rootResourcePath);
        return subResource;
    }

    public CaseDefinitionRestService getCaseDefinitionRestService(String engineName) {
        String rootResourcePath = this.getRelativeEngineUri(engineName).toASCIIString();
        CaseDefinitionRestServiceImpl subResource = new CaseDefinitionRestServiceImpl(engineName);
        subResource.setRelativeRootResourceUri(rootResourcePath);
        return subResource;
    }

    public CaseInstanceRestService getCaseInstanceRestService(String engineName) {
        String rootResourcePath = this.getRelativeEngineUri(engineName).toASCIIString();
        CaseInstanceRestServiceImpl subResource = new CaseInstanceRestServiceImpl(engineName);
        subResource.setRelativeRootResourceUri(rootResourcePath);
        return subResource;
    }

    public CaseExecutionRestService getCaseExecutionRestService(String engineName) {
        String rootResourcePath = this.getRelativeEngineUri(engineName).toASCIIString();
        CaseExecutionRestServiceImpl subResource = new CaseExecutionRestServiceImpl(engineName);
        subResource.setRelativeRootResourceUri(rootResourcePath);
        return subResource;
    }

    public List<ProcessEngineDto> getProcessEngineNames() {
        ProcessEngineProvider provider = this.getProcessEngineProvider();
        Set engineNames = provider.getProcessEngineNames();
        ArrayList<ProcessEngineDto> results = new ArrayList<ProcessEngineDto>();
        for (String engineName : engineNames) {
            ProcessEngineDto dto = new ProcessEngineDto();
            dto.setName(engineName);
            results.add(dto);
        }
        return results;
    }

    private URI getRelativeEngineUri(String engineName) {
        return UriBuilder.fromResource(ProcessEngineRestService.class).path("{name}").build(new Object[]{engineName});
    }

    private ProcessEngineProvider getProcessEngineProvider() {
        ServiceLoader<ProcessEngineProvider> serviceLoader = ServiceLoader.load(ProcessEngineProvider.class);
        Iterator<ProcessEngineProvider> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            ProcessEngineProvider provider = iterator.next();
            return provider;
        }
        throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, "No process engine provider found");
    }
}

