/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.impl;

import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.rest.dto.PatchVariablesDto;
import org.camunda.bpm.engine.rest.dto.runtime.VariableValueDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.mapper.MultipartFormData;
import org.camunda.bpm.engine.rest.sub.VariableResource;
import org.camunda.bpm.engine.rest.util.DtoUtil;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.type.JavaType;

public abstract class AbstractVariablesResource
implements VariableResource {
    protected ProcessEngine engine;
    protected String resourceId;

    public AbstractVariablesResource(ProcessEngine engine, String resourceId) {
        this.engine = engine;
        this.resourceId = resourceId;
    }

    public Map<String, VariableValueDto> getVariables() {
        HashMap<String, VariableValueDto> values = new HashMap<String, VariableValueDto>();
        for (Map.Entry entry : this.getVariableEntities().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            String simpleClassName = null;
            simpleClassName = value != null ? value.getClass().getSimpleName() : "Null";
            values.put(key, new VariableValueDto(value, simpleClassName));
        }
        return values;
    }

    public VariableValueDto getVariable(String variableName) {
        Object variable = null;
        try {
            variable = this.getVariableEntity(variableName);
        }
        catch (ProcessEngineException e) {
            String errorMessage = String.format("Cannot get %s variable %s: %s", this.getResourceTypeName(), variableName, e.getMessage());
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), errorMessage);
        }
        if (variable == null) {
            String errorMessage = String.format("%s variable with name %s does not exist or is null", this.getResourceTypeName(), variableName);
            throw new InvalidRequestException(Response.Status.NOT_FOUND, errorMessage);
        }
        return new VariableValueDto(variable, variable.getClass().getSimpleName());
    }

    public void putVariable(String variableName, VariableValueDto variable) {
        try {
            String type = variable.getType();
            Object value = variable.getValue();
            if (type != null && !type.equals("") && value != null) {
                if (type.equalsIgnoreCase("boolean")) {
                    this.setVariableEntity(variableName, (Object)Boolean.valueOf(value.toString()));
                    return;
                }
                if (type.equalsIgnoreCase("string")) {
                    this.setVariableEntity(variableName, (Object)String.valueOf(value));
                    return;
                }
                if (type.equalsIgnoreCase("integer")) {
                    this.setVariableEntity(variableName, (Object)Integer.valueOf(value.toString()));
                    return;
                }
                if (type.equalsIgnoreCase("short")) {
                    this.setVariableEntity(variableName, (Object)Short.valueOf(value.toString()));
                    return;
                }
                if (type.equalsIgnoreCase("long")) {
                    this.setVariableEntity(variableName, (Object)Long.valueOf(value.toString()));
                    return;
                }
                if (type.equalsIgnoreCase("double")) {
                    this.setVariableEntity(variableName, (Object)Double.valueOf(value.toString()));
                    return;
                }
                if (type.equalsIgnoreCase("date")) {
                    this.setVariableEntity(variableName, (Object)DtoUtil.toDate((Object)value));
                    return;
                }
                throw new IllegalArgumentException("The variable type '" + type + "' is not supported.");
            }
            this.setVariableEntity(variableName, variable.getValue());
        }
        catch (ProcessEngineException e) {
            String errorMessage = String.format("Cannot put %s variable %s: %s", this.getResourceTypeName(), variableName, e.getMessage());
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), errorMessage);
        }
        catch (NumberFormatException e) {
            String errorMessage = String.format("Cannot put %s variable %s due to number format exception: %s", this.getResourceTypeName(), variableName, e.getMessage());
            throw new RestException(Response.Status.BAD_REQUEST, (Exception)e, errorMessage);
        }
        catch (ParseException e) {
            String errorMessage = String.format("Cannot put %s variable %s due to parse exception: %s", this.getResourceTypeName(), variableName, e.getMessage());
            throw new RestException(Response.Status.BAD_REQUEST, (Exception)e, errorMessage);
        }
        catch (IllegalArgumentException e) {
            String errorMessage = String.format("Cannot put %s variable %s: %s", this.getResourceTypeName(), variableName, e.getMessage());
            throw new RestException(Response.Status.BAD_REQUEST, errorMessage);
        }
    }

    public void setBinaryVariable(String variableKey, MultipartFormData payload) {
        MultipartFormData.FormPart dataPart = payload.getNamedPart("data");
        MultipartFormData.FormPart typePart = payload.getNamedPart("type");
        if (typePart != null) {
            Object object = null;
            if (dataPart.getContentType() == null || !dataPart.getContentType().toLowerCase().contains("application/json")) {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Unrecognized content type for serialized java type: " + dataPart.getContentType());
            }
            object = this.deserializeJsonObject(typePart.getTextContent(), dataPart.getBinaryContent());
            if (object != null) {
                this.setVariableEntity(variableKey, object);
            }
        } else {
            try {
                this.setVariableEntity(variableKey, (Object)dataPart.getBinaryContent());
            }
            catch (ProcessEngineException e) {
                String errorMessage = String.format("Cannot put %s variable %s: %s", this.getResourceTypeName(), variableKey, e.getMessage());
                throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), errorMessage);
            }
        }
    }

    protected Object deserializeJsonObject(String className, byte[] data) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JavaType type = TypeFactory.fromCanonical(className);
            return objectMapper.readValue(new String(data), type);
        }
        catch (Exception e) {
            throw new InvalidRequestException(Response.Status.INTERNAL_SERVER_ERROR, "Could not deserialize JSON object: " + e.getMessage());
        }
    }

    public void deleteVariable(String variableName) {
        try {
            this.removeVariableEntity(variableName);
        }
        catch (ProcessEngineException e) {
            String errorMessage = String.format("Cannot delete %s variable %s: %s", this.getResourceTypeName(), variableName, e.getMessage());
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), errorMessage);
        }
    }

    public void modifyVariables(PatchVariablesDto patch) {
        Map variableModifications = null;
        try {
            variableModifications = DtoUtil.toMap((Map)patch.getModifications());
        }
        catch (NumberFormatException e) {
            String errorMessage = String.format("Cannot modify variables for %s due to number format exception: %s", this.getResourceTypeName(), e.getMessage());
            throw new RestException(Response.Status.BAD_REQUEST, (Exception)e, errorMessage);
        }
        catch (ParseException e) {
            String errorMessage = String.format("Cannot modify variables for %s due to parse exception: %s", this.getResourceTypeName(), e.getMessage());
            throw new RestException(Response.Status.BAD_REQUEST, (Exception)e, errorMessage);
        }
        catch (IllegalArgumentException e) {
            String errorMessage = String.format("Cannot modify variables for %s: %s", this.getResourceTypeName(), e.getMessage());
            throw new RestException(Response.Status.BAD_REQUEST, errorMessage);
        }
        List variableDeletions = patch.getDeletions();
        try {
            this.updateVariableEntities(variableModifications, variableDeletions);
        }
        catch (ProcessEngineException e) {
            String errorMessage = String.format("Cannot modify variables for %s %s: %s", this.getResourceTypeName(), this.resourceId, e.getMessage());
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), errorMessage);
        }
    }

    protected abstract Map<String, Object> getVariableEntities();

    protected abstract void updateVariableEntities(Map<String, Object> var1, List<String> var2);

    protected abstract Object getVariableEntity(String var1);

    protected abstract void setVariableEntity(String var1, Object var2);

    protected abstract void removeVariableEntity(String var1);

    protected abstract String getResourceTypeName();
}

