/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.repository.impl;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.text.ParseException;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.rest.CaseInstanceRestService;
import org.camunda.bpm.engine.rest.dto.repository.CaseDefinitionDiagramDto;
import org.camunda.bpm.engine.rest.dto.repository.CaseDefinitionDto;
import org.camunda.bpm.engine.rest.dto.runtime.CaseInstanceDto;
import org.camunda.bpm.engine.rest.dto.runtime.CreateCaseInstanceDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.sub.repository.CaseDefinitionResource;
import org.camunda.bpm.engine.rest.util.DtoUtil;
import org.camunda.bpm.engine.runtime.CaseInstance;

public class CaseDefinitionResourceImpl
implements CaseDefinitionResource {
    private ProcessEngine engine;
    private String caseDefinitionId;
    protected String rootResourcePath;

    public CaseDefinitionResourceImpl(ProcessEngine engine, String caseDefinitionId, String rootResourcePath) {
        this.engine = engine;
        this.caseDefinitionId = caseDefinitionId;
        this.rootResourcePath = rootResourcePath;
    }

    public CaseDefinitionDto getCaseDefinition() {
        CaseDefinition definition;
        RepositoryService repositoryService = this.engine.getRepositoryService();
        try {
            definition = repositoryService.getCaseDefinition(this.caseDefinitionId);
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, (Exception)((Object)e), "No matching definition with id " + this.caseDefinitionId);
        }
        return CaseDefinitionDto.fromCaseDefinition((CaseDefinition)definition);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CaseDefinitionDiagramDto getCaseDefinitionCmmnXml() {
        CaseDefinitionDiagramDto caseDefinitionDiagramDto;
        InputStream caseModelInputStream = null;
        try {
            caseModelInputStream = this.engine.getRepositoryService().getCaseModel(this.caseDefinitionId);
            byte[] caseModel = IoUtil.readInputStream((InputStream)caseModelInputStream, (String)"caseModelCmmnXml");
            caseDefinitionDiagramDto = CaseDefinitionDiagramDto.create((String)this.caseDefinitionId, (String)new String(caseModel, "UTF-8"));
        }
        catch (ProcessEngineException e) {
            try {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), "No matching definition with id " + this.caseDefinitionId);
                catch (UnsupportedEncodingException e2) {
                    throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)e2);
                }
            }
            catch (Throwable throwable) {
                IoUtil.closeSilently(caseModelInputStream);
                throw throwable;
            }
        }
        IoUtil.closeSilently((InputStream)caseModelInputStream);
        return caseDefinitionDiagramDto;
    }

    public CaseInstanceDto createCaseInstance(UriInfo context, CreateCaseInstanceDto parameters) {
        CaseService caseService = this.engine.getCaseService();
        CaseInstance instance = null;
        try {
            String businessKey = parameters.getBusinessKey();
            Map variables = DtoUtil.toMap((Map)parameters.getVariables());
            instance = caseService.withCaseDefinition(this.caseDefinitionId).businessKey(businessKey).setVariables(variables).create();
        }
        catch (ProcessEngineException e) {
            String errorMessage = String.format("Cannot instantiate case definition %s: %s", this.caseDefinitionId, e.getMessage());
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), errorMessage);
        }
        catch (NumberFormatException e) {
            String errorMessage = String.format("Cannot instantiate case definition %s due to number format exception: %s", this.caseDefinitionId, e.getMessage());
            throw new RestException(Response.Status.BAD_REQUEST, (Exception)e, errorMessage);
        }
        catch (ParseException e) {
            String errorMessage = String.format("Cannot instantiate case definition %s due to parse exception: %s", this.caseDefinitionId, e.getMessage());
            throw new RestException(Response.Status.BAD_REQUEST, (Exception)e, errorMessage);
        }
        catch (IllegalArgumentException e) {
            String errorMessage = String.format("Cannot instantiate case definition %s: %s", this.caseDefinitionId, e.getMessage());
            throw new RestException(Response.Status.BAD_REQUEST, errorMessage);
        }
        CaseInstanceDto result = CaseInstanceDto.fromCaseInstance((CaseInstance)instance);
        URI uri = context.getBaseUriBuilder().path(this.rootResourcePath).path(CaseInstanceRestService.class).path(instance.getId()).build(new Object[0]);
        result.addReflexiveLink(uri, "GET", "self");
        return result;
    }
}

