/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.runtime.impl;

import java.text.ParseException;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.rest.dto.runtime.CaseExecutionDto;
import org.camunda.bpm.engine.rest.dto.runtime.CaseExecutionTriggerDto;
import org.camunda.bpm.engine.rest.dto.runtime.TriggerVariableValueDto;
import org.camunda.bpm.engine.rest.dto.runtime.VariableNameDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.sub.VariableResource;
import org.camunda.bpm.engine.rest.sub.runtime.CaseExecutionResource;
import org.camunda.bpm.engine.rest.sub.runtime.impl.CaseExecutionVariablesResource;
import org.camunda.bpm.engine.rest.sub.runtime.impl.LocalCaseExecutionVariablesResource;
import org.camunda.bpm.engine.rest.util.DtoUtil;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseExecutionCommandBuilder;

public class CaseExecutionResourceImpl
implements CaseExecutionResource {
    protected ProcessEngine engine;
    protected String caseExecutionId;

    public CaseExecutionResourceImpl(ProcessEngine engine, String caseExecutionId) {
        this.engine = engine;
        this.caseExecutionId = caseExecutionId;
    }

    public CaseExecutionDto getCaseExecution() {
        CaseService caseService = this.engine.getCaseService();
        CaseExecution execution = (CaseExecution)caseService.createCaseExecutionQuery().caseExecutionId(this.caseExecutionId).singleResult();
        if (execution == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Case execution with id " + this.caseExecutionId + " does not exist.");
        }
        CaseExecutionDto result = CaseExecutionDto.fromCaseExecution((CaseExecution)execution);
        return result;
    }

    public void manualStart(CaseExecutionTriggerDto triggerDto) {
        try {
            CaseService caseService = this.engine.getCaseService();
            CaseExecutionCommandBuilder commandBuilder = caseService.withCaseExecution(this.caseExecutionId);
            this.initializeCommand(commandBuilder, triggerDto, "start manually");
            commandBuilder.manualStart();
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), "Cannot start case execution with id '" + this.caseExecutionId + "' manually.");
        }
    }

    public void disable(CaseExecutionTriggerDto triggerDto) {
        try {
            CaseService caseService = this.engine.getCaseService();
            CaseExecutionCommandBuilder commandBuilder = caseService.withCaseExecution(this.caseExecutionId);
            this.initializeCommand(commandBuilder, triggerDto, "disable");
            commandBuilder.disable();
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), "Cannot disable case execution with id '" + this.caseExecutionId + "'.");
        }
    }

    public void reenable(CaseExecutionTriggerDto triggerDto) {
        try {
            CaseService caseService = this.engine.getCaseService();
            CaseExecutionCommandBuilder commandBuilder = caseService.withCaseExecution(this.caseExecutionId);
            this.initializeCommand(commandBuilder, triggerDto, "reenable");
            commandBuilder.reenable();
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), "Cannot re-enable case execution with id '" + this.caseExecutionId + "'.");
        }
    }

    public void complete(CaseExecutionTriggerDto triggerDto) {
        try {
            CaseService caseService = this.engine.getCaseService();
            CaseExecutionCommandBuilder commandBuilder = caseService.withCaseExecution(this.caseExecutionId);
            this.initializeCommand(commandBuilder, triggerDto, "complete");
            commandBuilder.complete();
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), "Cannot complete case execution with id '" + this.caseExecutionId + "'.");
        }
    }

    protected void initializeCommand(CaseExecutionCommandBuilder commandBuilder, CaseExecutionTriggerDto triggerDto, String transition) {
        List deletions;
        Map variables = triggerDto.getVariables();
        if (variables != null && !variables.isEmpty()) {
            this.initializeCommandWithVariables(commandBuilder, variables, transition);
        }
        if ((deletions = triggerDto.getDeletions()) != null && !deletions.isEmpty()) {
            this.initializeCommandWithDeletions(commandBuilder, deletions, transition);
        }
    }

    protected void initializeCommandWithVariables(CaseExecutionCommandBuilder commandBuilder, Map<String, TriggerVariableValueDto> variables, String transition) {
        for (String variableName : variables.keySet()) {
            String errorMessage;
            try {
                TriggerVariableValueDto variableValue = variables.get(variableName);
                Object value = DtoUtil.toType((String)variableValue.getType(), (Object)variableValue.getValue());
                if (variableValue.isLocal()) {
                    commandBuilder.setVariableLocal(variableName, value);
                    continue;
                }
                commandBuilder.setVariable(variableName, value);
            }
            catch (NumberFormatException e) {
                errorMessage = String.format("Cannot %s case execution %s due to number format exception of variable %s: %s", transition, this.caseExecutionId, variableName, e.getMessage());
                throw new RestException(Response.Status.BAD_REQUEST, (Exception)e, errorMessage);
            }
            catch (ParseException e) {
                errorMessage = String.format("Cannot %s case execution %s due to parse exception of variable %s: %s", transition, variableName, variableName, e.getMessage());
                throw new RestException(Response.Status.BAD_REQUEST, (Exception)e, errorMessage);
            }
            catch (IllegalArgumentException e) {
                errorMessage = String.format("Cannot %s case execution %s because of variable %s: %s", transition, variableName, variableName, e.getMessage());
                throw new RestException(Response.Status.BAD_REQUEST, errorMessage);
            }
        }
    }

    protected void initializeCommandWithDeletions(CaseExecutionCommandBuilder commandBuilder, List<VariableNameDto> deletions, String transition) {
        for (VariableNameDto variableName : deletions) {
            if (variableName.isLocal()) {
                commandBuilder.removeVariableLocal(variableName.getName());
                continue;
            }
            commandBuilder.removeVariable(variableName.getName());
        }
    }

    public VariableResource getVariablesLocal() {
        return new LocalCaseExecutionVariablesResource(this.engine, this.caseExecutionId);
    }

    public VariableResource getVariables() {
        return new CaseExecutionVariablesResource(this.engine, this.caseExecutionId);
    }
}

