/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.runtime.impl;

import java.text.ParseException;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.rest.dto.runtime.CaseExecutionTriggerDto;
import org.camunda.bpm.engine.rest.dto.runtime.CaseInstanceDto;
import org.camunda.bpm.engine.rest.dto.runtime.TriggerVariableValueDto;
import org.camunda.bpm.engine.rest.dto.runtime.VariableNameDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.sub.VariableResource;
import org.camunda.bpm.engine.rest.sub.runtime.CaseInstanceResource;
import org.camunda.bpm.engine.rest.sub.runtime.impl.CaseExecutionVariablesResource;
import org.camunda.bpm.engine.rest.util.DtoUtil;
import org.camunda.bpm.engine.runtime.CaseExecutionCommandBuilder;
import org.camunda.bpm.engine.runtime.CaseInstance;

public class CaseInstanceResourceImpl
implements CaseInstanceResource {
    protected ProcessEngine engine;
    protected String caseInstanceId;

    public CaseInstanceResourceImpl(ProcessEngine engine, String caseInstanceId) {
        this.engine = engine;
        this.caseInstanceId = caseInstanceId;
    }

    public CaseInstanceDto getCaseInstance() {
        CaseService caseService = this.engine.getCaseService();
        CaseInstance instance = (CaseInstance)caseService.createCaseInstanceQuery().caseInstanceId(this.caseInstanceId).singleResult();
        if (instance == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Case instance with id " + this.caseInstanceId + " does not exist.");
        }
        CaseInstanceDto result = CaseInstanceDto.fromCaseInstance((CaseInstance)instance);
        return result;
    }

    public void complete(CaseExecutionTriggerDto triggerDto) {
        try {
            CaseService caseService = this.engine.getCaseService();
            CaseExecutionCommandBuilder commandBuilder = caseService.withCaseExecution(this.caseInstanceId);
            this.initializeCommand(commandBuilder, triggerDto, "complete");
            commandBuilder.complete();
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), "Cannot complete case instance with id '" + this.caseInstanceId + "'.");
        }
    }

    public void close(CaseExecutionTriggerDto triggerDto) {
        try {
            CaseService caseService = this.engine.getCaseService();
            CaseExecutionCommandBuilder commandBuilder = caseService.withCaseExecution(this.caseInstanceId);
            this.initializeCommand(commandBuilder, triggerDto, "close");
            commandBuilder.close();
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), "Cannot close case instance with id '" + this.caseInstanceId + "'.");
        }
    }

    protected void initializeCommand(CaseExecutionCommandBuilder commandBuilder, CaseExecutionTriggerDto triggerDto, String transition) {
        List deletions;
        Map variables = triggerDto.getVariables();
        if (variables != null && !variables.isEmpty()) {
            this.initializeCommandWithVariables(commandBuilder, variables, transition);
        }
        if ((deletions = triggerDto.getDeletions()) != null && !deletions.isEmpty()) {
            this.initializeCommandWithDeletions(commandBuilder, deletions, transition);
        }
    }

    protected void initializeCommandWithVariables(CaseExecutionCommandBuilder commandBuilder, Map<String, TriggerVariableValueDto> variables, String transition) {
        for (String variableName : variables.keySet()) {
            String errorMessage;
            try {
                TriggerVariableValueDto variableValue = variables.get(variableName);
                Object value = DtoUtil.toType((String)variableValue.getType(), (Object)variableValue.getValue());
                if (variableValue.isLocal()) {
                    commandBuilder.setVariableLocal(variableName, value);
                    continue;
                }
                commandBuilder.setVariable(variableName, value);
            }
            catch (NumberFormatException e) {
                errorMessage = String.format("Cannot %s case instance %s due to number format exception of variable %s: %s", transition, this.caseInstanceId, variableName, e.getMessage());
                throw new RestException(Response.Status.BAD_REQUEST, (Exception)e, errorMessage);
            }
            catch (ParseException e) {
                errorMessage = String.format("Cannot %s case instance %s due to parse exception of variable %s: %s", transition, variableName, variableName, e.getMessage());
                throw new RestException(Response.Status.BAD_REQUEST, (Exception)e, errorMessage);
            }
            catch (IllegalArgumentException e) {
                errorMessage = String.format("Cannot %s case instance %s because of variable %s: %s", transition, variableName, variableName, e.getMessage());
                throw new RestException(Response.Status.BAD_REQUEST, errorMessage);
            }
        }
    }

    protected void initializeCommandWithDeletions(CaseExecutionCommandBuilder commandBuilder, List<VariableNameDto> deletions, String transition) {
        for (VariableNameDto variableName : deletions) {
            if (variableName.isLocal()) {
                commandBuilder.removeVariableLocal(variableName.getName());
                continue;
            }
            commandBuilder.removeVariable(variableName.getName());
        }
    }

    public VariableResource getVariablesResource() {
        return new CaseExecutionVariablesResource(this.engine, this.caseInstanceId);
    }
}

