/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.runtime.impl;

import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.rest.dto.runtime.JobDto;
import org.camunda.bpm.engine.rest.dto.runtime.JobDuedateDto;
import org.camunda.bpm.engine.rest.dto.runtime.JobRetriesDto;
import org.camunda.bpm.engine.rest.dto.runtime.JobSuspensionStateDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.sub.runtime.JobResource;
import org.camunda.bpm.engine.runtime.Job;

public class JobResourceImpl
implements JobResource {
    private ProcessEngine engine;
    private String jobId;

    public JobResourceImpl(ProcessEngine engine, String jobId) {
        this.engine = engine;
        this.jobId = jobId;
    }

    public JobDto getJob() {
        ManagementService managementService = this.engine.getManagementService();
        Job job = (Job)managementService.createJobQuery().jobId(this.jobId).singleResult();
        if (job == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Job with id " + this.jobId + " does not exist");
        }
        return JobDto.fromJob((Job)job);
    }

    public String getStacktrace() {
        try {
            ManagementService managementService = this.engine.getManagementService();
            String stacktrace = managementService.getJobExceptionStacktrace(this.jobId);
            return stacktrace;
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, e.getMessage());
        }
    }

    public void setJobRetries(JobRetriesDto dto) {
        try {
            ManagementService managementService = this.engine.getManagementService();
            managementService.setJobRetries(this.jobId, dto.getRetries());
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    public void executeJob() {
        try {
            ManagementService managementService = this.engine.getManagementService();
            managementService.executeJob(this.jobId);
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, e.getMessage());
        }
        catch (RuntimeException r) {
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, r.getMessage());
        }
    }

    public void setJobDuedate(JobDuedateDto dto) {
        try {
            ManagementService managementService = this.engine.getManagementService();
            managementService.setJobDuedate(this.jobId, dto.getDuedate());
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    public void updateSuspensionState(JobSuspensionStateDto dto) {
        dto.setJobId(this.jobId);
        dto.updateSuspensionState(this.engine);
    }
}

