/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.runtime;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.VariableQueryParameterDto;
import org.camunda.bpm.engine.rest.dto.converter.BooleanConverter;
import org.camunda.bpm.engine.rest.dto.converter.VariableListConverter;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.runtime.CaseInstanceQuery;

public class CaseInstanceQueryDto
extends AbstractQueryDto<CaseInstanceQuery> {
    protected static final String SORT_BY_INSTANCE_ID_VALUE = "caseInstanceId";
    protected static final String SORT_BY_DEFINITION_KEY_VALUE = "caseDefinitionKey";
    protected static final String SORT_BY_DEFINITION_ID_VALUE = "caseDefinitionId";
    protected static final List<String> VALID_SORT_BY_VALUES = new ArrayList();
    protected String caseInstanceId;
    protected String businessKey;
    protected String caseDefinitionKey;
    protected String caseDefinitionId;
    protected Boolean active;
    protected Boolean completed;
    protected List<VariableQueryParameterDto> variables;

    public CaseInstanceQueryDto() {
    }

    public CaseInstanceQueryDto(MultivaluedMap<String, String> queryParameters) {
        super(queryParameters);
    }

    @CamundaQueryParam(value="caseInstanceId")
    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @CamundaQueryParam(value="businessKey")
    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    @CamundaQueryParam(value="caseDefinitionKey")
    public void setCaseDefinitionKey(String caseDefinitionKey) {
        this.caseDefinitionKey = caseDefinitionKey;
    }

    @CamundaQueryParam(value="caseDefinitionId")
    public void setCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    @CamundaQueryParam(value="active", converter=BooleanConverter.class)
    public void setActive(Boolean active) {
        this.active = active;
    }

    @CamundaQueryParam(value="completed", converter=BooleanConverter.class)
    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    @CamundaQueryParam(value="variables", converter=VariableListConverter.class)
    public void setVariables(List<VariableQueryParameterDto> variables) {
        this.variables = variables;
    }

    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    protected CaseInstanceQuery createNewQuery(ProcessEngine engine) {
        return engine.getCaseService().createCaseInstanceQuery();
    }

    protected void applyFilters(CaseInstanceQuery query) {
        if (this.caseInstanceId != null) {
            query.caseInstanceId(this.caseInstanceId);
        }
        if (this.businessKey != null) {
            query.caseInstanceBusinessKey(this.businessKey);
        }
        if (this.caseDefinitionKey != null) {
            query.caseDefinitionKey(this.caseDefinitionKey);
        }
        if (this.caseDefinitionId != null) {
            query.caseDefinitionId(this.caseDefinitionId);
        }
        if (this.active != null && this.active.booleanValue()) {
            query.active();
        }
        if (this.completed != null && this.completed.booleanValue()) {
            query.completed();
        }
        if (this.variables != null) {
            for (VariableQueryParameterDto variableQueryParam : this.variables) {
                String variableName = variableQueryParam.getName();
                String op = variableQueryParam.getOperator();
                Object variableValue = variableQueryParam.getValue();
                if (op.equals("eq")) {
                    query.variableValueEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("gt")) {
                    query.variableValueGreaterThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("gteq")) {
                    query.variableValueGreaterThanOrEqual(variableName, variableValue);
                    continue;
                }
                if (op.equals("lt")) {
                    query.variableValueLessThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("lteq")) {
                    query.variableValueLessThanOrEqual(variableName, variableValue);
                    continue;
                }
                if (op.equals("neq")) {
                    query.variableValueNotEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("like")) {
                    query.variableValueLike(variableName, String.valueOf(variableValue));
                    continue;
                }
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Invalid variable comparator specified: " + op);
            }
        }
    }

    protected void applySortingOptions(CaseInstanceQuery query) {
        if (this.sortBy != null) {
            if (this.sortBy.equals(SORT_BY_INSTANCE_ID_VALUE)) {
                query.orderByCaseInstanceId();
            } else if (this.sortBy.equals(SORT_BY_DEFINITION_KEY_VALUE)) {
                query.orderByCaseDefinitionKey();
            } else if (this.sortBy.equals(SORT_BY_DEFINITION_ID_VALUE)) {
                query.orderByCaseDefinitionId();
            }
        }
        if (this.sortOrder != null) {
            if (this.sortOrder.equals("asc")) {
                query.asc();
            } else if (this.sortOrder.equals("desc")) {
                query.desc();
            }
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_INSTANCE_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_DEFINITION_KEY_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_DEFINITION_ID_VALUE);
    }
}

