/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.runtime;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.ConditionQueryParameterDto;
import org.camunda.bpm.engine.rest.dto.converter.BooleanConverter;
import org.camunda.bpm.engine.rest.dto.converter.ConditionListConverter;
import org.camunda.bpm.engine.rest.dto.converter.DateConverter;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.runtime.JobQuery;

public class JobQueryDto
extends AbstractQueryDto<JobQuery> {
    private static final String SORT_BY_JOB_ID_VALUE = "jobId";
    private static final String SORT_BY_EXECUTION_ID_VALUE = "executionId";
    private static final String SORT_BY_PROCESS_INSTANCE_ID_VALUE = "processInstanceId";
    private static final String SORT_BY_PROCESS_DEFINITION_ID_VALUE = "processDefinitionId";
    private static final String SORT_BY_PROCESS_DEFINITION_KEY_VALUE = "processDefinitionKey";
    private static final String SORT_BY_JOB_RETRIES_VALUE = "jobRetries";
    private static final String SORT_BY_JOB_DUEDATE_VALUE = "jobDueDate";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList();
    private String jobId;
    private String executionId;
    private String processInstanceId;
    private String processDefinitionId;
    private String processDefinitionKey;
    private Boolean withRetriesLeft;
    private Boolean executable;
    private Boolean timers;
    private Boolean messages;
    private Boolean withException;
    private String exceptionMessage;
    private Boolean noRetriesLeft;
    private Boolean active;
    private Boolean suspended;
    private List<ConditionQueryParameterDto> dueDates;

    public JobQueryDto() {
    }

    public JobQueryDto(MultivaluedMap<String, String> queryParameters) {
        super(queryParameters);
    }

    @CamundaQueryParam(value="jobId")
    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    @CamundaQueryParam(value="executionId")
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @CamundaQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @CamundaQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @CamundaQueryParam(value="processDefinitionKey")
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @CamundaQueryParam(value="withRetriesLeft", converter=BooleanConverter.class)
    public void setWithRetriesLeft(Boolean withRetriesLeft) {
        this.withRetriesLeft = withRetriesLeft;
    }

    @CamundaQueryParam(value="executable", converter=BooleanConverter.class)
    public void setExecutable(Boolean executable) {
        this.executable = executable;
    }

    @CamundaQueryParam(value="timers", converter=BooleanConverter.class)
    public void setTimers(Boolean timers) {
        this.timers = timers;
    }

    @CamundaQueryParam(value="withException", converter=BooleanConverter.class)
    public void setWithException(Boolean withException) {
        this.withException = withException;
    }

    @CamundaQueryParam(value="messages", converter=BooleanConverter.class)
    public void setMessages(Boolean messages) {
        this.messages = messages;
    }

    @CamundaQueryParam(value="exceptionMessage")
    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    @CamundaQueryParam(value="dueDates", converter=ConditionListConverter.class)
    public void setDueDates(List<ConditionQueryParameterDto> dueDates) {
        this.dueDates = dueDates;
    }

    @CamundaQueryParam(value="noRetriesLeft", converter=BooleanConverter.class)
    public void setNoRetriesLeft(Boolean noRetriesLeft) {
        this.noRetriesLeft = noRetriesLeft;
    }

    @CamundaQueryParam(value="active", converter=BooleanConverter.class)
    public void setActive(Boolean active) {
        this.active = active;
    }

    @CamundaQueryParam(value="suspended", converter=BooleanConverter.class)
    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    protected JobQuery createNewQuery(ProcessEngine engine) {
        return engine.getManagementService().createJobQuery();
    }

    protected void applyFilters(JobQuery query) {
        if (this.jobId != null) {
            query.jobId(this.jobId);
        }
        if (this.executionId != null) {
            query.executionId(this.executionId);
        }
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.processDefinitionKey != null) {
            query.processDefinitionKey(this.processDefinitionKey);
        }
        if (this.withRetriesLeft != null && this.withRetriesLeft.booleanValue()) {
            query.withRetriesLeft();
        }
        if (this.executable != null && this.executable.booleanValue()) {
            query.executable();
        }
        if (this.timers != null && this.timers.booleanValue()) {
            if (this.messages != null && this.messages.booleanValue()) {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Parameter timers cannot be used together with parameter messages.");
            }
            query.timers();
        }
        if (this.messages != null && this.messages.booleanValue()) {
            if (this.timers != null && this.timers.booleanValue()) {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Parameter messages cannot be used together with parameter timers.");
            }
            query.messages();
        }
        if (this.withException != null && this.withException.booleanValue()) {
            query.withException();
        }
        if (this.exceptionMessage != null) {
            query.exceptionMessage(this.exceptionMessage);
        }
        if (this.noRetriesLeft != null && this.noRetriesLeft.booleanValue()) {
            query.noRetriesLeft();
        }
        if (this.active != null && this.active.booleanValue()) {
            query.active();
        }
        if (this.suspended != null && this.suspended.booleanValue()) {
            query.suspended();
        }
        if (this.dueDates != null) {
            DateConverter dateConverter = new DateConverter();
            for (ConditionQueryParameterDto conditionQueryParam : this.dueDates) {
                String op = conditionQueryParam.getOperator();
                Date dueDate = null;
                try {
                    dueDate = dateConverter.convertQueryParameterToType((String)conditionQueryParam.getValue());
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)e, "Invalid due date format: " + e.getMessage());
                }
                if (op.equals("gt")) {
                    query.duedateHigherThan(dueDate);
                    continue;
                }
                if (op.equals("lt")) {
                    query.duedateLowerThan(dueDate);
                    continue;
                }
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Invalid due date comparator specified: " + op);
            }
        }
    }

    protected void applySortingOptions(JobQuery query) {
        if (this.sortBy != null) {
            if (this.sortBy.equals(SORT_BY_JOB_ID_VALUE)) {
                query.orderByJobId();
            } else if (this.sortBy.equals(SORT_BY_EXECUTION_ID_VALUE)) {
                query.orderByExecutionId();
            } else if (this.sortBy.equals(SORT_BY_PROCESS_INSTANCE_ID_VALUE)) {
                query.orderByProcessInstanceId();
            } else if (this.sortBy.equals(SORT_BY_PROCESS_DEFINITION_ID_VALUE)) {
                query.orderByProcessDefinitionId();
            } else if (this.sortBy.equals(SORT_BY_PROCESS_DEFINITION_KEY_VALUE)) {
                query.orderByProcessDefinitionKey();
            } else if (this.sortBy.equals(SORT_BY_JOB_RETRIES_VALUE)) {
                query.orderByJobRetries();
            } else if (this.sortBy.equals(SORT_BY_JOB_DUEDATE_VALUE)) {
                query.orderByJobDuedate();
            }
        }
        if (this.sortOrder != null) {
            if (this.sortOrder.equals("asc")) {
                query.asc();
            } else if (this.sortOrder.equals("desc")) {
                query.desc();
            }
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_JOB_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_EXECUTION_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_KEY_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_JOB_RETRIES_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_JOB_DUEDATE_VALUE);
    }
}

