/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.GroupQuery;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.rest.IdentityRestService;
import org.camunda.bpm.engine.rest.dto.task.GroupDto;
import org.camunda.bpm.engine.rest.dto.task.GroupInfoDto;
import org.camunda.bpm.engine.rest.dto.task.UserDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;

public class IdentityRestServiceImpl
extends AbstractRestProcessEngineAware
implements IdentityRestService {
    public IdentityRestServiceImpl() {
    }

    public IdentityRestServiceImpl(String engineName) {
        super(engineName);
    }

    public GroupInfoDto getGroupInfo(String userId) {
        if (userId == null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "No user id was supplied");
        }
        IdentityService identityService = this.getProcessEngine().getIdentityService();
        GroupQuery query = identityService.createGroupQuery();
        List userGroups = ((GroupQuery)query.groupMember(userId).orderByGroupName().asc()).list();
        HashSet<UserDto> allGroupUsers = new HashSet<UserDto>();
        ArrayList<GroupDto> allGroups = new ArrayList<GroupDto>();
        for (Group group : userGroups) {
            List groupUsers = identityService.createUserQuery().memberOfGroup(group.getId()).list();
            for (User user : groupUsers) {
                if (user.getId().equals(userId)) continue;
                allGroupUsers.add(new UserDto(user.getId(), user.getFirstName(), user.getLastName()));
            }
            allGroups.add(new GroupDto(group.getId(), group.getName()));
        }
        return new GroupInfoDto(allGroups, allGroupUsers);
    }
}

