/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl.history;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.history.HistoricTaskInstanceQuery;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricTaskInstanceDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricTaskInstanceQueryDto;
import org.camunda.bpm.engine.rest.history.HistoricTaskInstanceRestService;

public class HistoricTaskInstanceRestServiceImpl
implements HistoricTaskInstanceRestService {
    protected ProcessEngine processEngine;

    public HistoricTaskInstanceRestServiceImpl(ProcessEngine processEngine) {
        this.processEngine = processEngine;
    }

    public List<HistoricTaskInstanceDto> getHistoricTaskInstances(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        HistoricTaskInstanceQueryDto queryDto = new HistoricTaskInstanceQueryDto(uriInfo.getQueryParameters());
        return this.queryHistoricTaskInstances(queryDto, firstResult, maxResults);
    }

    public List<HistoricTaskInstanceDto> queryHistoricTaskInstances(HistoricTaskInstanceQueryDto queryDto, Integer firstResult, Integer maxResults) {
        HistoricTaskInstanceQuery query = (HistoricTaskInstanceQuery)queryDto.toQuery(this.processEngine);
        List match = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        ArrayList<HistoricTaskInstanceDto> result = new ArrayList<HistoricTaskInstanceDto>();
        for (HistoricTaskInstance taskInstance : match) {
            HistoricTaskInstanceDto taskInstanceDto = HistoricTaskInstanceDto.fromHistoricTaskInstance((HistoricTaskInstance)taskInstance);
            result.add(taskInstanceDto);
        }
        return result;
    }

    private List<HistoricTaskInstance> executePaginatedQuery(HistoricTaskInstanceQuery query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }

    public CountResultDto getHistoricTaskInstancesCount(UriInfo uriInfo) {
        HistoricTaskInstanceQueryDto queryDto = new HistoricTaskInstanceQueryDto(uriInfo.getQueryParameters());
        return this.queryHistoricTaskInstancesCount(queryDto);
    }

    public CountResultDto queryHistoricTaskInstancesCount(HistoricTaskInstanceQueryDto queryDto) {
        HistoricTaskInstanceQuery query = (HistoricTaskInstanceQuery)queryDto.toQuery(this.processEngine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

