/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.task.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.rest.TaskRestService;
import org.camunda.bpm.engine.rest.dto.task.CommentDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.mapper.MultipartFormData;
import org.camunda.bpm.engine.rest.sub.task.TaskCommentResource;
import org.camunda.bpm.engine.task.Comment;

public class TaskCommentResourceImpl
implements TaskCommentResource {
    private ProcessEngine engine;
    private String taskId;
    private String rootResourcePath;

    public TaskCommentResourceImpl(ProcessEngine engine, String taskId, String rootResourcePath) {
        this.engine = engine;
        this.taskId = taskId;
        this.rootResourcePath = rootResourcePath;
    }

    public List<CommentDto> getComments() {
        if (!this.isHistoryEnabled()) {
            return Collections.emptyList();
        }
        this.ensureTaskExists(Response.Status.NOT_FOUND);
        List taskComments = this.engine.getTaskService().getTaskComments(this.taskId);
        ArrayList<CommentDto> comments = new ArrayList<CommentDto>();
        for (Comment comment : taskComments) {
            comments.add(CommentDto.fromComment((Comment)comment));
        }
        return comments;
    }

    public CommentDto getComment(String commentId) {
        this.ensureHistoryEnabled(Response.Status.NOT_FOUND);
        Comment comment = this.engine.getTaskService().getTaskComment(this.taskId, commentId);
        if (comment == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Task comment with id " + commentId + " does not exist for task id '" + this.taskId + "'.");
        }
        return CommentDto.fromComment((Comment)comment);
    }

    public CommentDto createComment(UriInfo uriInfo, MultipartFormData payload) {
        Comment comment;
        this.ensureHistoryEnabled(Response.Status.FORBIDDEN);
        this.ensureTaskExists(Response.Status.BAD_REQUEST);
        MultipartFormData.FormPart messagePart = payload.getNamedPart("message");
        String message = null;
        if (messagePart != null) {
            message = messagePart.getTextContent();
        }
        try {
            comment = this.engine.getTaskService().addComment(this.taskId, null, message);
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), "Not enough parameters submitted");
        }
        URI uri = uriInfo.getBaseUriBuilder().path(this.rootResourcePath).path(TaskRestService.class).path(this.taskId + "/comment/" + comment.getId()).build(new Object[0]);
        CommentDto commentDto = CommentDto.fromComment((Comment)comment);
        commentDto.addReflexiveLink(uri, "GET", "self");
        return commentDto;
    }

    private boolean isHistoryEnabled() {
        int historyLevel = this.engine.getManagementService().getHistoryLevel();
        return historyLevel > 0;
    }

    private void ensureHistoryEnabled(Response.Status status) {
        if (!this.isHistoryEnabled()) {
            throw new InvalidRequestException(status, "History is not enabled");
        }
    }

    private void ensureTaskExists(Response.Status status) {
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)this.engine.getHistoryService().createHistoricTaskInstanceQuery().taskId(this.taskId).singleResult();
        if (historicTaskInstance == null) {
            throw new InvalidRequestException(status, "No task found for task id " + this.taskId);
        }
    }
}

