/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.authorization;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.rest.dto.converter.PermissionConverter;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuthorizationDto {
    protected String id;
    protected Integer type;
    protected String[] permissions;
    protected String userId;
    protected String groupId;
    protected Integer resourceType;
    protected String resourceId;

    public static AuthorizationDto fromAuthorization(Authorization dbAuthorization) {
        AuthorizationDto authorizationDto = new AuthorizationDto();
        authorizationDto.setId(dbAuthorization.getId());
        authorizationDto.setType(dbAuthorization.getAuthorizationType());
        Permission[] dbPermissions = dbAuthorization.getPermissions((Permission[])Permissions.values());
        authorizationDto.setPermissions(PermissionConverter.getNamesForPermissions((Authorization)dbAuthorization, (Permission[])dbPermissions));
        authorizationDto.setUserId(dbAuthorization.getUserId());
        authorizationDto.setGroupId(dbAuthorization.getGroupId());
        authorizationDto.setResourceType(Integer.valueOf(dbAuthorization.getResourceType()));
        authorizationDto.setResourceId(dbAuthorization.getResourceId());
        return authorizationDto;
    }

    public static void update(AuthorizationDto dto, Authorization dbAuthorization) {
        dbAuthorization.setGroupId(dto.getGroupId());
        dbAuthorization.setUserId(dto.getUserId());
        dbAuthorization.setResourceId(dto.getResourceId());
        if (dto.getResourceType() != null) {
            dbAuthorization.setResourceType(dto.getResourceType().intValue());
        }
        if (dto.getPermissions() != null) {
            dbAuthorization.setPermissions(PermissionConverter.getPermissionsForNames((String[])dto.getPermissions()));
        }
    }

    public static List<AuthorizationDto> fromAuthorizationList(List<Authorization> resultList) {
        ArrayList<AuthorizationDto> result = new ArrayList<AuthorizationDto>();
        for (Authorization authorization : resultList) {
            result.add(AuthorizationDto.fromAuthorization((Authorization)authorization));
        }
        return result;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String[] getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String[] permissions) {
        this.permissions = permissions;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public Integer getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(Integer resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }
}

