/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.history;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.VariableQueryParameterDto;
import org.camunda.bpm.engine.rest.dto.converter.BooleanConverter;
import org.camunda.bpm.engine.rest.dto.converter.DateConverter;
import org.camunda.bpm.engine.rest.dto.converter.StringListConverter;
import org.camunda.bpm.engine.rest.dto.converter.StringSetConverter;
import org.camunda.bpm.engine.rest.dto.converter.VariableListConverter;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.codehaus.jackson.map.ObjectMapper;

public class HistoricProcessInstanceQueryDto
extends AbstractQueryDto<HistoricProcessInstanceQuery> {
    private static final String SORT_BY_PROCESS_INSTANCE_ID_VALUE = "instanceId";
    private static final String SORT_BY_PROCESS_DEFINITION_ID_VALUE = "definitionId";
    private static final String SORT_BY_PROCESS_INSTANCE_BUSINESS_KEY_VALUE = "businessKey";
    private static final String SORT_BY_PROCESS_INSTANCE_START_TIME_VALUE = "startTime";
    private static final String SORT_BY_PROCESS_INSTANCE_END_TIME_VALUE = "endTime";
    private static final String SORT_BY_PROCESS_INSTANCE_DURATION_VALUE = "duration";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList();
    private String processInstanceId;
    private Set<String> processInstanceIds;
    private String processDefinitionId;
    private String processDefinitionKey;
    private String processDefinitionName;
    private String processDefinitionNameLike;
    private List<String> processDefinitionKeyNotIn;
    private String processInstanceBusinessKey;
    private String processInstanceBusinessKeyLike;
    private Boolean finished;
    private Boolean unfinished;
    private Date startedBefore;
    private Date startedAfter;
    private Date finishedBefore;
    private Date finishedAfter;
    private String startedBy;
    private String superProcessInstanceId;
    private String subProcessInstanceId;
    private String superCaseInstanceId;
    private String subCaseInstanceId;
    private String caseInstanceId;
    private List<VariableQueryParameterDto> variables;

    public HistoricProcessInstanceQueryDto() {
    }

    public HistoricProcessInstanceQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @CamundaQueryParam(value="processInstanceIds", converter=StringSetConverter.class)
    public void setProcessInstanceIds(Set<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
    }

    @CamundaQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @CamundaQueryParam(value="processDefinitionName")
    public void setProcessDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
    }

    @CamundaQueryParam(value="processDefinitionNameLike")
    public void setProcessDefinitionNameLike(String processDefinitionNameLike) {
        this.processDefinitionNameLike = processDefinitionNameLike;
    }

    @CamundaQueryParam(value="processDefinitionKey")
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @CamundaQueryParam(value="processDefinitionKeyNotIn", converter=StringListConverter.class)
    public void setProcessDefinitionKeyNotIn(List<String> processDefinitionKeys) {
        this.processDefinitionKeyNotIn = processDefinitionKeys;
    }

    @CamundaQueryParam(value="processInstanceBusinessKey")
    public void setProcessInstanceBusinessKey(String processInstanceBusinessKey) {
        this.processInstanceBusinessKey = processInstanceBusinessKey;
    }

    @CamundaQueryParam(value="processInstanceBusinessKeyLike")
    public void setProcessInstanceBusinessKeyLike(String processInstanceBusinessKeyLike) {
        this.processInstanceBusinessKeyLike = processInstanceBusinessKeyLike;
    }

    @CamundaQueryParam(value="finished", converter=BooleanConverter.class)
    public void setFinished(Boolean finished) {
        this.finished = finished;
    }

    @CamundaQueryParam(value="unfinished", converter=BooleanConverter.class)
    public void setUnfinished(Boolean unfinished) {
        this.unfinished = unfinished;
    }

    @CamundaQueryParam(value="startedBefore", converter=DateConverter.class)
    public void setStartedBefore(Date startedBefore) {
        this.startedBefore = startedBefore;
    }

    @CamundaQueryParam(value="startedAfter", converter=DateConverter.class)
    public void setStartedAfter(Date startedAfter) {
        this.startedAfter = startedAfter;
    }

    @CamundaQueryParam(value="finishedBefore", converter=DateConverter.class)
    public void setFinishedBefore(Date finishedBefore) {
        this.finishedBefore = finishedBefore;
    }

    @CamundaQueryParam(value="finishedAfter", converter=DateConverter.class)
    public void setFinishedAfter(Date finishedAfter) {
        this.finishedAfter = finishedAfter;
    }

    @CamundaQueryParam(value="startedBy")
    public void setStartedBy(String startedBy) {
        this.startedBy = startedBy;
    }

    @CamundaQueryParam(value="superProcessInstanceId")
    public void setSuperProcessInstanceId(String superProcessInstanceId) {
        this.superProcessInstanceId = superProcessInstanceId;
    }

    @CamundaQueryParam(value="subProcessInstanceId")
    public void setSubProcessInstanceId(String subProcessInstanceId) {
        this.subProcessInstanceId = subProcessInstanceId;
    }

    @CamundaQueryParam(value="superCaseInstanceId")
    public void setSuperCaseInstanceId(String superCaseInstanceId) {
        this.superCaseInstanceId = superCaseInstanceId;
    }

    @CamundaQueryParam(value="subCaseInstanceId")
    public void setSubCaseInstanceId(String subCaseInstanceId) {
        this.subCaseInstanceId = subCaseInstanceId;
    }

    @CamundaQueryParam(value="caseInstanceId")
    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @CamundaQueryParam(value="variables", converter=VariableListConverter.class)
    public void setVariables(List<VariableQueryParameterDto> variables) {
        this.variables = variables;
    }

    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    protected HistoricProcessInstanceQuery createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createHistoricProcessInstanceQuery();
    }

    protected void applyFilters(HistoricProcessInstanceQuery query) {
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.processInstanceIds != null) {
            query.processInstanceIds(this.processInstanceIds);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.processDefinitionKey != null) {
            query.processDefinitionKey(this.processDefinitionKey);
        }
        if (this.processDefinitionName != null) {
            query.processDefinitionName(this.processDefinitionName);
        }
        if (this.processDefinitionNameLike != null) {
            query.processDefinitionNameLike(this.processDefinitionNameLike);
        }
        if (this.processDefinitionKeyNotIn != null) {
            query.processDefinitionKeyNotIn(this.processDefinitionKeyNotIn);
        }
        if (this.processInstanceBusinessKey != null) {
            query.processInstanceBusinessKey(this.processInstanceBusinessKey);
        }
        if (this.processInstanceBusinessKeyLike != null) {
            query.processInstanceBusinessKeyLike(this.processInstanceBusinessKeyLike);
        }
        if (this.finished != null && this.finished.booleanValue()) {
            query.finished();
        }
        if (this.unfinished != null && this.unfinished.booleanValue()) {
            query.unfinished();
        }
        if (this.startedBefore != null) {
            query.startedBefore(this.startedBefore);
        }
        if (this.startedAfter != null) {
            query.startedAfter(this.startedAfter);
        }
        if (this.finishedBefore != null) {
            query.finishedBefore(this.finishedBefore);
        }
        if (this.finishedAfter != null) {
            query.finishedAfter(this.finishedAfter);
        }
        if (this.startedBy != null) {
            query.startedBy(this.startedBy);
        }
        if (this.superProcessInstanceId != null) {
            query.superProcessInstanceId(this.superProcessInstanceId);
        }
        if (this.subProcessInstanceId != null) {
            query.subProcessInstanceId(this.subProcessInstanceId);
        }
        if (this.superCaseInstanceId != null) {
            query.superCaseInstanceId(this.superCaseInstanceId);
        }
        if (this.subCaseInstanceId != null) {
            query.subCaseInstanceId(this.subCaseInstanceId);
        }
        if (this.caseInstanceId != null) {
            query.caseInstanceId(this.caseInstanceId);
        }
        if (this.variables != null) {
            for (VariableQueryParameterDto variableQueryParam : this.variables) {
                String variableName = variableQueryParam.getName();
                String op = variableQueryParam.getOperator();
                Object variableValue = variableQueryParam.resolveValue(this.objectMapper);
                if (op.equals("eq")) {
                    query.variableValueEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("gt")) {
                    query.variableValueGreaterThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("gteq")) {
                    query.variableValueGreaterThanOrEqual(variableName, variableValue);
                    continue;
                }
                if (op.equals("lt")) {
                    query.variableValueLessThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("lteq")) {
                    query.variableValueLessThanOrEqual(variableName, variableValue);
                    continue;
                }
                if (op.equals("neq")) {
                    query.variableValueNotEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("like")) {
                    query.variableValueLike(variableName, String.valueOf(variableValue));
                    continue;
                }
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Invalid variable comparator specified: " + op);
            }
        }
    }

    protected void applySortingOptions(HistoricProcessInstanceQuery query) {
        if (this.sortBy != null) {
            if (this.sortBy.equals(SORT_BY_PROCESS_INSTANCE_ID_VALUE)) {
                query.orderByProcessInstanceId();
            } else if (this.sortBy.equals(SORT_BY_PROCESS_DEFINITION_ID_VALUE)) {
                query.orderByProcessDefinitionId();
            } else if (this.sortBy.equals(SORT_BY_PROCESS_INSTANCE_BUSINESS_KEY_VALUE)) {
                query.orderByProcessInstanceBusinessKey();
            } else if (this.sortBy.equals(SORT_BY_PROCESS_INSTANCE_START_TIME_VALUE)) {
                query.orderByProcessInstanceStartTime();
            } else if (this.sortBy.equals(SORT_BY_PROCESS_INSTANCE_END_TIME_VALUE)) {
                query.orderByProcessInstanceEndTime();
            } else if (this.sortBy.equals(SORT_BY_PROCESS_INSTANCE_DURATION_VALUE)) {
                query.orderByProcessInstanceDuration();
            }
        }
        if (this.sortOrder != null) {
            if (this.sortOrder.equals("asc")) {
                query.asc();
            } else if (this.sortOrder.equals("desc")) {
                query.desc();
            }
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_BUSINESS_KEY_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_START_TIME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_END_TIME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_DURATION_VALUE);
    }
}

