/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.history;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.converter.StringArrayConverter;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.codehaus.jackson.map.ObjectMapper;

public class HistoricVariableInstanceQueryDto
extends AbstractQueryDto<HistoricVariableInstanceQuery> {
    private static final String SORT_BY_PROCESS_INSTANCE_ID_VALUE = "instanceId";
    private static final String SORT_BY_VARIABLE_NAME_VALUE = "variableName";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList();
    protected String processInstanceId;
    protected String caseInstanceId;
    protected String variableName;
    protected String variableNameLike;
    protected Object variableValue;
    protected String[] executionIdIn;
    protected String[] taskIdIn;
    protected String[] activityInstanceIdIn;
    protected String[] caseExecutionIdIn;

    public HistoricVariableInstanceQueryDto() {
    }

    public HistoricVariableInstanceQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @CamundaQueryParam(value="caseInstanceId")
    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @CamundaQueryParam(value="variableName")
    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    @CamundaQueryParam(value="variableNameLike")
    public void setVariableNameLike(String variableNameLike) {
        this.variableNameLike = variableNameLike;
    }

    @CamundaQueryParam(value="variableValue")
    public void setVariableValue(Object variableValue) {
        this.variableValue = variableValue;
    }

    @CamundaQueryParam(value="executionIdIn", converter=StringArrayConverter.class)
    public void setExecutionIdIn(String[] executionIdIn) {
        this.executionIdIn = executionIdIn;
    }

    @CamundaQueryParam(value="taskIdIn", converter=StringArrayConverter.class)
    public void setTaskIdIn(String[] taskIdIn) {
        this.taskIdIn = taskIdIn;
    }

    @CamundaQueryParam(value="activityInstanceIdIn", converter=StringArrayConverter.class)
    public void setActivityInstanceIdIn(String[] activityInstanceIdIn) {
        this.activityInstanceIdIn = activityInstanceIdIn;
    }

    @CamundaQueryParam(value="caseExecutionIdIn", converter=StringArrayConverter.class)
    public void setCaseExecutionIdIn(String[] caseExecutionIdIn) {
        this.caseExecutionIdIn = caseExecutionIdIn;
    }

    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    protected HistoricVariableInstanceQuery createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createHistoricVariableInstanceQuery();
    }

    protected void applyFilters(HistoricVariableInstanceQuery query) {
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.caseInstanceId != null) {
            query.caseInstanceId(this.caseInstanceId);
        }
        if (this.variableName != null) {
            query.variableName(this.variableName);
        }
        if (this.variableNameLike != null) {
            query.variableNameLike(this.variableNameLike);
        }
        if (this.variableValue != null) {
            if (this.variableName != null) {
                query.variableValueEquals(this.variableName, this.variableValue);
            } else {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Only a single variable value parameter specified: variable name and value are required to be able to query after a specific variable value.");
            }
        }
        if (this.executionIdIn != null && this.executionIdIn.length > 0) {
            query.executionIdIn(this.executionIdIn);
        }
        if (this.taskIdIn != null && this.taskIdIn.length > 0) {
            query.taskIdIn(this.taskIdIn);
        }
        if (this.activityInstanceIdIn != null && this.activityInstanceIdIn.length > 0) {
            query.activityInstanceIdIn(this.activityInstanceIdIn);
        }
        if (this.caseExecutionIdIn != null && this.caseExecutionIdIn.length > 0) {
            query.caseExecutionIdIn(this.caseExecutionIdIn);
        }
    }

    protected void applySortingOptions(HistoricVariableInstanceQuery query) {
        if (this.sortBy != null) {
            if (this.sortBy.equals(SORT_BY_PROCESS_INSTANCE_ID_VALUE)) {
                query.orderByProcessInstanceId();
            } else if (this.sortBy.equals(SORT_BY_VARIABLE_NAME_VALUE)) {
                query.orderByVariableName();
            }
            if (this.sortOrder != null) {
                if (this.sortOrder.equals("asc")) {
                    query.asc();
                } else if (this.sortOrder.equals("desc")) {
                    query.desc();
                }
            }
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_VARIABLE_NAME_VALUE);
    }
}

