/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.management;

import java.util.Date;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.rest.dto.SuspensionStateDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;

public class JobDefinitionSuspensionStateDto
extends SuspensionStateDto {
    private String executionDate;
    private boolean includeJobs;
    private String jobDefinitionId;
    private String processDefinitionId;
    private String processDefinitionKey;

    public String getJobDefinitionId() {
        return this.jobDefinitionId;
    }

    public void setJobDefinitionId(String jobDefinitionId) {
        this.jobDefinitionId = jobDefinitionId;
    }

    public void setExecutionDate(String executionDate) {
        this.executionDate = executionDate;
    }

    public void setIncludeJobs(boolean includeJobs) {
        this.includeJobs = includeJobs;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public void updateSuspensionState(ProcessEngine engine) {
        int params = (this.jobDefinitionId != null ? 1 : 0) + (this.processDefinitionId != null ? 1 : 0) + (this.processDefinitionKey != null ? 1 : 0);
        if (params > 1) {
            String message = "Only one of jobDefinitionId, processDefinitionId or processDefinitionKey should be set to update the suspension state.";
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, message);
        }
        ManagementService managementService = engine.getManagementService();
        Date delayedExecutionDate = null;
        if (this.executionDate != null && !this.executionDate.equals("")) {
            delayedExecutionDate = DateTimeUtil.parseDate((String)this.executionDate);
        }
        if (this.jobDefinitionId != null) {
            if (this.getSuspended()) {
                managementService.suspendJobDefinitionById(this.jobDefinitionId, this.includeJobs, delayedExecutionDate);
            } else {
                managementService.activateJobDefinitionById(this.jobDefinitionId, this.includeJobs, delayedExecutionDate);
            }
        } else if (this.processDefinitionId != null) {
            if (this.getSuspended()) {
                managementService.suspendJobDefinitionByProcessDefinitionId(this.processDefinitionId, this.includeJobs, delayedExecutionDate);
            } else {
                managementService.activateJobDefinitionByProcessDefinitionId(this.processDefinitionId, this.includeJobs, delayedExecutionDate);
            }
        } else if (this.processDefinitionKey != null) {
            if (this.getSuspended()) {
                managementService.suspendJobDefinitionByProcessDefinitionKey(this.processDefinitionKey, this.includeJobs, delayedExecutionDate);
            } else {
                managementService.activateJobDefinitionByProcessDefinitionKey(this.processDefinitionKey, this.includeJobs, delayedExecutionDate);
            }
        } else {
            String message = "Either jobDefinitionId, processDefinitionId or processDefinitionKey should be set to update the suspension state.";
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, message);
        }
    }
}

