/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.repository;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.repository.CaseDefinitionQuery;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.converter.BooleanConverter;
import org.camunda.bpm.engine.rest.dto.converter.IntegerConverter;
import org.codehaus.jackson.map.ObjectMapper;

public class CaseDefinitionQueryDto
extends AbstractQueryDto<CaseDefinitionQuery> {
    private static final String SORT_BY_ID_VALUE = "id";
    private static final String SORT_BY_KEY_VALUE = "key";
    private static final String SORT_BY_NAME_VALUE = "name";
    private static final String SORT_BY_VERSION_VALUE = "version";
    private static final String SORT_BY_DEPLOYMENT_ID_VALUE = "deploymentId";
    private static final String SORT_BY_CATEGORY_VALUE = "category";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList();
    protected String caseDefinitionId;
    protected String category;
    protected String categoryLike;
    protected String name;
    protected String nameLike;
    protected String deploymentId;
    protected String key;
    protected String keyLike;
    protected String resourceName;
    protected String resourceNameLike;
    protected Integer version;
    protected Boolean latestVersion;

    public CaseDefinitionQueryDto() {
    }

    public CaseDefinitionQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="caseDefinitionId")
    public void setCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    @CamundaQueryParam(value="category")
    public void setCategory(String category) {
        this.category = category;
    }

    @CamundaQueryParam(value="categoryLike")
    public void setCategoryLike(String categoryLike) {
        this.categoryLike = categoryLike;
    }

    @CamundaQueryParam(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @CamundaQueryParam(value="nameLike")
    public void setNameLike(String nameLike) {
        this.nameLike = nameLike;
    }

    @CamundaQueryParam(value="deploymentId")
    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    @CamundaQueryParam(value="key")
    public void setKey(String key) {
        this.key = key;
    }

    @CamundaQueryParam(value="keyLike")
    public void setKeyLike(String keyLike) {
        this.keyLike = keyLike;
    }

    @CamundaQueryParam(value="resourceName")
    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    @CamundaQueryParam(value="resourceNameLike")
    public void setResourceNameLike(String resourceNameLike) {
        this.resourceNameLike = resourceNameLike;
    }

    @CamundaQueryParam(value="version", converter=IntegerConverter.class)
    public void setVersion(Integer version) {
        this.version = version;
    }

    @Deprecated
    @CamundaQueryParam(value="latest", converter=BooleanConverter.class)
    public void setLatest(Boolean latest) {
        this.setLatestVersion(latest);
    }

    @CamundaQueryParam(value="latestVersion", converter=BooleanConverter.class)
    public void setLatestVersion(Boolean latestVersion) {
        this.latestVersion = latestVersion;
    }

    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    protected CaseDefinitionQuery createNewQuery(ProcessEngine engine) {
        return engine.getRepositoryService().createCaseDefinitionQuery();
    }

    protected void applyFilters(CaseDefinitionQuery query) {
        if (this.caseDefinitionId != null) {
            query.caseDefinitionId(this.caseDefinitionId);
        }
        if (this.category != null) {
            query.caseDefinitionCategory(this.category);
        }
        if (this.categoryLike != null) {
            query.caseDefinitionCategoryLike(this.categoryLike);
        }
        if (this.name != null) {
            query.caseDefinitionName(this.name);
        }
        if (this.nameLike != null) {
            query.caseDefinitionNameLike(this.nameLike);
        }
        if (this.deploymentId != null) {
            query.deploymentId(this.deploymentId);
        }
        if (this.key != null) {
            query.caseDefinitionKey(this.key);
        }
        if (this.keyLike != null) {
            query.caseDefinitionKeyLike(this.keyLike);
        }
        if (this.resourceName != null) {
            query.caseDefinitionResourceName(this.resourceName);
        }
        if (this.resourceNameLike != null) {
            query.caseDefinitionResourceNameLike(this.resourceNameLike);
        }
        if (this.version != null) {
            query.caseDefinitionVersion(this.version);
        }
        if (this.latestVersion != null && this.latestVersion.booleanValue()) {
            query.latestVersion();
        }
    }

    protected void applySortingOptions(CaseDefinitionQuery query) {
        if (this.sortBy != null) {
            if (this.sortBy.equals(SORT_BY_CATEGORY_VALUE)) {
                query.orderByCaseDefinitionCategory();
            } else if (this.sortBy.equals(SORT_BY_KEY_VALUE)) {
                query.orderByCaseDefinitionKey();
            } else if (this.sortBy.equals(SORT_BY_ID_VALUE)) {
                query.orderByCaseDefinitionId();
            } else if (this.sortBy.equals(SORT_BY_VERSION_VALUE)) {
                query.orderByCaseDefinitionVersion();
            } else if (this.sortBy.equals(SORT_BY_NAME_VALUE)) {
                query.orderByCaseDefinitionName();
            } else if (this.sortBy.equals(SORT_BY_DEPLOYMENT_ID_VALUE)) {
                query.orderByDeploymentId();
            }
        }
        if (this.sortOrder != null) {
            if (this.sortOrder.equals("asc")) {
                query.asc();
            } else if (this.sortOrder.equals("desc")) {
                query.desc();
            }
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_CATEGORY_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_KEY_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_NAME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_VERSION_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_DEPLOYMENT_ID_VALUE);
    }
}

