/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.repository;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.converter.BooleanConverter;
import org.camunda.bpm.engine.rest.dto.converter.IntegerConverter;
import org.codehaus.jackson.map.ObjectMapper;

public class ProcessDefinitionQueryDto
extends AbstractQueryDto<ProcessDefinitionQuery> {
    private static final String SORT_BY_CATEGORY_VALUE = "category";
    private static final String SORT_BY_KEY_VALUE = "key";
    private static final String SORT_BY_ID_VALUE = "id";
    private static final String SORT_BY_NAME_VALUE = "name";
    private static final String SORT_BY_VERSION_VALUE = "version";
    private static final String SORT_BY_DEPLOYMENT_ID_VALUE = "deploymentId";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList();
    private String category;
    private String categoryLike;
    private String name;
    private String nameLike;
    private String deploymentId;
    private String key;
    private String keyLike;
    private Integer version;
    private Boolean latestVersion;
    private String resourceName;
    private String resourceNameLike;
    private String startableBy;
    private Boolean active;
    private Boolean suspended;
    private String incidentId;
    private String incidentType;
    private String incidentMessage;
    private String incidentMessageLike;

    public ProcessDefinitionQueryDto() {
    }

    public ProcessDefinitionQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="category")
    public void setCategory(String category) {
        this.category = category;
    }

    @CamundaQueryParam(value="categoryLike")
    public void setCategoryLike(String categoryLike) {
        this.categoryLike = categoryLike;
    }

    @CamundaQueryParam(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @CamundaQueryParam(value="nameLike")
    public void setNameLike(String nameLike) {
        this.nameLike = nameLike;
    }

    @CamundaQueryParam(value="deploymentId")
    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    @CamundaQueryParam(value="key")
    public void setKey(String key) {
        this.key = key;
    }

    @CamundaQueryParam(value="keyLike")
    public void setKeyLike(String keyLike) {
        this.keyLike = keyLike;
    }

    @Deprecated
    @CamundaQueryParam(value="ver", converter=IntegerConverter.class)
    public void setVer(Integer ver) {
        this.setVersion(ver);
    }

    @CamundaQueryParam(value="version", converter=IntegerConverter.class)
    public void setVersion(Integer version) {
        this.version = version;
    }

    @Deprecated
    @CamundaQueryParam(value="latest", converter=BooleanConverter.class)
    public void setLatest(Boolean latest) {
        this.setLatestVersion(latest);
    }

    @CamundaQueryParam(value="latestVersion", converter=BooleanConverter.class)
    public void setLatestVersion(Boolean latestVersion) {
        this.latestVersion = latestVersion;
    }

    @CamundaQueryParam(value="resourceName")
    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    @CamundaQueryParam(value="resourceNameLike")
    public void setResourceNameLike(String resourceNameLike) {
        this.resourceNameLike = resourceNameLike;
    }

    @CamundaQueryParam(value="startableBy")
    public void setStartableBy(String startableBy) {
        this.startableBy = startableBy;
    }

    @CamundaQueryParam(value="active", converter=BooleanConverter.class)
    public void setActive(Boolean active) {
        this.active = active;
    }

    @CamundaQueryParam(value="suspended", converter=BooleanConverter.class)
    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    @CamundaQueryParam(value="incidentId")
    public void setIncidentId(String incidentId) {
        this.incidentId = incidentId;
    }

    @CamundaQueryParam(value="incidentType")
    public void setIncidentType(String incidentType) {
        this.incidentType = incidentType;
    }

    @CamundaQueryParam(value="incidentMessage")
    public void setIncidentMessage(String incidentMessage) {
        this.incidentMessage = incidentMessage;
    }

    @CamundaQueryParam(value="incidentMessageLike")
    public void setIncidentMessageLike(String incidentMessageLike) {
        this.incidentMessageLike = incidentMessageLike;
    }

    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    protected ProcessDefinitionQuery createNewQuery(ProcessEngine engine) {
        return engine.getRepositoryService().createProcessDefinitionQuery();
    }

    protected void applyFilters(ProcessDefinitionQuery query) {
        if (this.category != null) {
            query.processDefinitionCategory(this.category);
        }
        if (this.categoryLike != null) {
            query.processDefinitionCategoryLike(this.categoryLike);
        }
        if (this.name != null) {
            query.processDefinitionName(this.name);
        }
        if (this.nameLike != null) {
            query.processDefinitionNameLike(this.nameLike);
        }
        if (this.deploymentId != null) {
            query.deploymentId(this.deploymentId);
        }
        if (this.key != null) {
            query.processDefinitionKey(this.key);
        }
        if (this.keyLike != null) {
            query.processDefinitionKeyLike(this.keyLike);
        }
        if (this.version != null) {
            query.processDefinitionVersion(this.version);
        }
        if (this.latestVersion != null && this.latestVersion.booleanValue()) {
            query.latestVersion();
        }
        if (this.resourceName != null) {
            query.processDefinitionResourceName(this.resourceName);
        }
        if (this.resourceNameLike != null) {
            query.processDefinitionResourceNameLike(this.resourceNameLike);
        }
        if (this.startableBy != null) {
            query.startableByUser(this.startableBy);
        }
        if (this.active != null && this.active.booleanValue()) {
            query.active();
        }
        if (this.suspended != null && this.suspended.booleanValue()) {
            query.suspended();
        }
        if (this.incidentId != null) {
            query.incidentId(this.incidentId);
        }
        if (this.incidentType != null) {
            query.incidentType(this.incidentType);
        }
        if (this.incidentMessage != null) {
            query.incidentMessage(this.incidentMessage);
        }
        if (this.incidentMessageLike != null) {
            query.incidentMessageLike(this.incidentMessageLike);
        }
    }

    protected void applySortingOptions(ProcessDefinitionQuery query) {
        if (this.sortBy != null) {
            if (this.sortBy.equals(SORT_BY_CATEGORY_VALUE)) {
                query.orderByProcessDefinitionCategory();
            } else if (this.sortBy.equals(SORT_BY_KEY_VALUE)) {
                query.orderByProcessDefinitionKey();
            } else if (this.sortBy.equals(SORT_BY_ID_VALUE)) {
                query.orderByProcessDefinitionId();
            } else if (this.sortBy.equals(SORT_BY_VERSION_VALUE)) {
                query.orderByProcessDefinitionVersion();
            } else if (this.sortBy.equals(SORT_BY_NAME_VALUE)) {
                query.orderByProcessDefinitionName();
            } else if (this.sortBy.equals(SORT_BY_DEPLOYMENT_ID_VALUE)) {
                query.orderByDeploymentId();
            }
        }
        if (this.sortOrder != null) {
            if (this.sortOrder.equals("asc")) {
                query.asc();
            } else if (this.sortOrder.equals("desc")) {
                query.desc();
            }
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_CATEGORY_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_KEY_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_NAME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_VERSION_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_DEPLOYMENT_ID_VALUE);
    }
}

