/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.runtime;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.VariableQueryParameterDto;
import org.camunda.bpm.engine.rest.dto.converter.BooleanConverter;
import org.camunda.bpm.engine.rest.dto.converter.VariableListConverter;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.runtime.CaseExecutionQuery;
import org.codehaus.jackson.map.ObjectMapper;

public class CaseExecutionQueryDto
extends AbstractQueryDto<CaseExecutionQuery> {
    protected static final String SORT_BY_EXECUTION_ID_VALUE = "caseExecutionId";
    protected static final String SORT_BY_DEFINITION_KEY_VALUE = "caseDefinitionKey";
    protected static final String SORT_BY_DEFINITION_ID_VALUE = "caseDefinitionId";
    protected static final List<String> VALID_SORT_BY_VALUES = new ArrayList();
    protected String caseExecutionId;
    protected String caseDefinitionKey;
    protected String caseDefinitionId;
    protected String caseInstanceId;
    protected String businessKey;
    protected String activityId;
    protected Boolean enabled;
    protected Boolean active;
    protected Boolean disabled;
    protected List<VariableQueryParameterDto> variables;
    protected List<VariableQueryParameterDto> caseInstanceVariables;

    public CaseExecutionQueryDto() {
    }

    public CaseExecutionQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="caseExecutionId")
    public void setCaseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
    }

    @CamundaQueryParam(value="caseDefinitionKey")
    public void setCaseDefinitionKey(String caseDefinitionKey) {
        this.caseDefinitionKey = caseDefinitionKey;
    }

    @CamundaQueryParam(value="caseDefinitionId")
    public void setCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    @CamundaQueryParam(value="caseInstanceId")
    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @CamundaQueryParam(value="businessKey")
    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    @CamundaQueryParam(value="activityId")
    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @CamundaQueryParam(value="enabled", converter=BooleanConverter.class)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @CamundaQueryParam(value="active", converter=BooleanConverter.class)
    public void setActive(Boolean active) {
        this.active = active;
    }

    @CamundaQueryParam(value="disabled", converter=BooleanConverter.class)
    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    @CamundaQueryParam(value="variables", converter=VariableListConverter.class)
    public void setVariables(List<VariableQueryParameterDto> variables) {
        this.variables = variables;
    }

    @CamundaQueryParam(value="caseInstanceVariables", converter=VariableListConverter.class)
    public void setCaseInstanceVariables(List<VariableQueryParameterDto> caseInstanceVariables) {
        this.caseInstanceVariables = caseInstanceVariables;
    }

    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    protected CaseExecutionQuery createNewQuery(ProcessEngine engine) {
        return engine.getCaseService().createCaseExecutionQuery();
    }

    protected void applyFilters(CaseExecutionQuery query) {
        Object variableValue;
        String op;
        String variableName;
        if (this.caseExecutionId != null) {
            query.caseExecutionId(this.caseExecutionId);
        }
        if (this.caseInstanceId != null) {
            query.caseInstanceId(this.caseInstanceId);
        }
        if (this.businessKey != null) {
            query.caseInstanceBusinessKey(this.businessKey);
        }
        if (this.caseDefinitionKey != null) {
            query.caseDefinitionKey(this.caseDefinitionKey);
        }
        if (this.caseDefinitionId != null) {
            query.caseDefinitionId(this.caseDefinitionId);
        }
        if (this.activityId != null) {
            query.activityId(this.activityId);
        }
        if (this.active != null && this.active.booleanValue()) {
            query.active();
        }
        if (this.enabled != null && this.enabled.booleanValue()) {
            query.enabled();
        }
        if (this.disabled != null && this.disabled.booleanValue()) {
            query.disabled();
        }
        if (this.variables != null) {
            for (VariableQueryParameterDto variableQueryParam : this.variables) {
                variableName = variableQueryParam.getName();
                op = variableQueryParam.getOperator();
                variableValue = variableQueryParam.resolveValue(this.objectMapper);
                if (op.equals("eq")) {
                    query.variableValueEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("gt")) {
                    query.variableValueGreaterThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("gteq")) {
                    query.variableValueGreaterThanOrEqual(variableName, variableValue);
                    continue;
                }
                if (op.equals("lt")) {
                    query.variableValueLessThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("lteq")) {
                    query.variableValueLessThanOrEqual(variableName, variableValue);
                    continue;
                }
                if (op.equals("neq")) {
                    query.variableValueNotEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("like")) {
                    query.variableValueLike(variableName, String.valueOf(variableValue));
                    continue;
                }
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Invalid variable comparator specified: " + op);
            }
        }
        if (this.caseInstanceVariables != null) {
            for (VariableQueryParameterDto variableQueryParam : this.caseInstanceVariables) {
                variableName = variableQueryParam.getName();
                op = variableQueryParam.getOperator();
                variableValue = variableQueryParam.resolveValue(this.objectMapper);
                if (op.equals("eq")) {
                    query.caseInstanceVariableValueEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("gt")) {
                    query.caseInstanceVariableValueGreaterThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("gteq")) {
                    query.caseInstanceVariableValueGreaterThanOrEqual(variableName, variableValue);
                    continue;
                }
                if (op.equals("lt")) {
                    query.caseInstanceVariableValueLessThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("lteq")) {
                    query.caseInstanceVariableValueLessThanOrEqual(variableName, variableValue);
                    continue;
                }
                if (op.equals("neq")) {
                    query.caseInstanceVariableValueNotEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("like")) {
                    query.caseInstanceVariableValueLike(variableName, String.valueOf(variableValue));
                    continue;
                }
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Invalid variable comparator specified: " + op);
            }
        }
    }

    protected void applySortingOptions(CaseExecutionQuery query) {
        if (this.sortBy != null) {
            if (this.sortBy.equals(SORT_BY_EXECUTION_ID_VALUE)) {
                query.orderByCaseExecutionId();
            } else if (this.sortBy.equals(SORT_BY_DEFINITION_KEY_VALUE)) {
                query.orderByCaseDefinitionKey();
            } else if (this.sortBy.equals(SORT_BY_DEFINITION_ID_VALUE)) {
                query.orderByCaseDefinitionId();
            }
        }
        if (this.sortOrder != null) {
            if (this.sortOrder.equals("asc")) {
                query.asc();
            } else if (this.sortOrder.equals("desc")) {
                query.desc();
            }
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_EXECUTION_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_DEFINITION_KEY_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_DEFINITION_ID_VALUE);
    }
}

