/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.runtime;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.runtime.IncidentQuery;
import org.codehaus.jackson.map.ObjectMapper;

public class IncidentQueryDto
extends AbstractQueryDto<IncidentQuery> {
    private static final String SORT_BY_INCIDENT_ID = "incidentId";
    private static final String SORT_BY_INCIDENT_TIMESTAMP = "incidentTimestamp";
    private static final String SORT_BY_INCIDENT_TYPE = "incidentType";
    private static final String SORT_BY_EXECUTION_ID = "executionId";
    private static final String SORT_BY_ACTIVITY_ID = "activityId";
    private static final String SORT_BY_PROCESS_INSTANCE_ID = "processInstanceId";
    private static final String SORT_BY_PROCESS_DEFINITION_ID = "processDefinitionId";
    private static final String SORT_BY_CAUSE_INCIDENT_ID = "causeIncidentId";
    private static final String SORT_BY_ROOT_CAUSE_INCIDENT_ID = "rootCauseIncidentId";
    private static final String SORT_BY_CONFIGURATION = "configuration";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList();
    protected String incidentId;
    protected String incidentType;
    protected String incidentMessage;
    protected String processDefinitionId;
    protected String processInstanceId;
    protected String executionId;
    protected String activityId;
    protected String causeIncidentId;
    protected String rootCauseIncidentId;
    protected String configuration;

    public IncidentQueryDto() {
    }

    public IncidentQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="incidentId")
    public void setIncidentId(String incidentId) {
        this.incidentId = incidentId;
    }

    @CamundaQueryParam(value="incidentType")
    public void setIncidentType(String incidentType) {
        this.incidentType = incidentType;
    }

    @CamundaQueryParam(value="incidentMessage")
    public void setIncidentMessage(String incidentMessage) {
        this.incidentMessage = incidentMessage;
    }

    @CamundaQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @CamundaQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @CamundaQueryParam(value="executionId")
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @CamundaQueryParam(value="activityId")
    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @CamundaQueryParam(value="causeIncidentId")
    public void setCauseIncidentId(String causeIncidentId) {
        this.causeIncidentId = causeIncidentId;
    }

    @CamundaQueryParam(value="rootCauseIncidentId")
    public void setRootCauseIncidentId(String rootCauseIncidentId) {
        this.rootCauseIncidentId = rootCauseIncidentId;
    }

    @CamundaQueryParam(value="configuration")
    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    protected IncidentQuery createNewQuery(ProcessEngine engine) {
        return engine.getRuntimeService().createIncidentQuery();
    }

    protected void applyFilters(IncidentQuery query) {
        if (this.incidentId != null) {
            query.incidentId(this.incidentId);
        }
        if (this.incidentType != null) {
            query.incidentType(this.incidentType);
        }
        if (this.incidentMessage != null) {
            query.incidentMessage(this.incidentMessage);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.executionId != null) {
            query.executionId(this.executionId);
        }
        if (this.activityId != null) {
            query.activityId(this.activityId);
        }
        if (this.causeIncidentId != null) {
            query.causeIncidentId(this.causeIncidentId);
        }
        if (this.rootCauseIncidentId != null) {
            query.rootCauseIncidentId(this.rootCauseIncidentId);
        }
        if (this.configuration != null) {
            query.configuration(this.configuration);
        }
    }

    protected void applySortingOptions(IncidentQuery query) {
        if (this.sortBy != null) {
            if (this.sortBy.equals(SORT_BY_INCIDENT_ID)) {
                query.orderByIncidentId();
            } else if (this.sortBy.equals(SORT_BY_INCIDENT_TIMESTAMP)) {
                query.orderByIncidentTimestamp();
            } else if (this.sortBy.equals(SORT_BY_INCIDENT_TYPE)) {
                query.orderByIncidentType();
            } else if (this.sortBy.equals(SORT_BY_EXECUTION_ID)) {
                query.orderByExecutionId();
            } else if (this.sortBy.equals(SORT_BY_ACTIVITY_ID)) {
                query.orderByActivityId();
            } else if (this.sortBy.equals(SORT_BY_PROCESS_INSTANCE_ID)) {
                query.orderByProcessInstanceId();
            } else if (this.sortBy.equals(SORT_BY_PROCESS_DEFINITION_ID)) {
                query.orderByProcessDefinitionId();
            } else if (this.sortBy.equals(SORT_BY_CAUSE_INCIDENT_ID)) {
                query.orderByCauseIncidentId();
            } else if (this.sortBy.equals(SORT_BY_ROOT_CAUSE_INCIDENT_ID)) {
                query.orderByRootCauseIncidentId();
            } else if (this.sortBy.equals(SORT_BY_CONFIGURATION)) {
                query.orderByConfiguration();
            }
        }
        if (this.sortOrder != null) {
            if (this.sortOrder.equals("asc")) {
                query.asc();
            } else if (this.sortOrder.equals("desc")) {
                query.desc();
            }
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_INCIDENT_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_INCIDENT_TIMESTAMP);
        VALID_SORT_BY_VALUES.add(SORT_BY_INCIDENT_TYPE);
        VALID_SORT_BY_VALUES.add(SORT_BY_EXECUTION_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_ACTIVITY_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_CAUSE_INCIDENT_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_ROOT_CAUSE_INCIDENT_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_CONFIGURATION);
    }
}

