/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.TaskQueryImpl;
import org.camunda.bpm.engine.impl.TaskQueryVariableValue;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.VariableQueryParameterDto;
import org.camunda.bpm.engine.rest.dto.converter.BooleanConverter;
import org.camunda.bpm.engine.rest.dto.converter.DateConverter;
import org.camunda.bpm.engine.rest.dto.converter.DelegationStateConverter;
import org.camunda.bpm.engine.rest.dto.converter.IntegerConverter;
import org.camunda.bpm.engine.rest.dto.converter.StringArrayConverter;
import org.camunda.bpm.engine.rest.dto.converter.StringListConverter;
import org.camunda.bpm.engine.rest.dto.converter.VariableListConverter;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.task.DelegationState;
import org.camunda.bpm.engine.task.TaskQuery;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class TaskQueryDto
extends AbstractQueryDto<TaskQuery> {
    private static final String SORT_BY_PROCESS_INSTANCE_ID_VALUE = "instanceId";
    private static final String SORT_BY_CASE_INSTANCE_ID_VALUE = "caseInstanceId";
    private static final String SORT_BY_DUE_DATE_VALUE = "dueDate";
    private static final String SORT_BY_FOLLOW_UP_VALUE = "followUpDate";
    private static final String SORT_BY_EXECUTION_ID_VALUE = "executionId";
    private static final String SORT_BY_CASE_EXECUTION_ID_VALUE = "caseExecutionId";
    private static final String SORT_BY_ASSIGNEE_VALUE = "assignee";
    private static final String SORT_BY_CREATE_TIME_VALUE = "created";
    private static final String SORT_BY_DESCRIPTION_VALUE = "description";
    private static final String SORT_BY_ID_VALUE = "id";
    private static final String SORT_BY_NAME_VALUE = "name";
    private static final String SORT_BY_NAME_CASE_INSENSITIVE_VALUE = "nameCaseInsensitive";
    private static final String SORT_BY_PRIORITY_VALUE = "priority";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList();
    private String processInstanceBusinessKey;
    private String processInstanceBusinessKeyLike;
    private String processDefinitionKey;
    private String processDefinitionId;
    private String executionId;
    private String[] activityInstanceIdIn;
    private String processDefinitionName;
    private String processDefinitionNameLike;
    private String processInstanceId;
    private String assignee;
    private String assigneeExpression;
    private String assigneeLike;
    private String assigneeLikeExpression;
    private String candidateGroup;
    private String candidateGroupExpression;
    private String candidateUser;
    private String candidateUserExpression;
    private String taskDefinitionKey;
    private String taskDefinitionKeyLike;
    private String description;
    private String descriptionLike;
    private String involvedUser;
    private String involvedUserExpression;
    private Integer maxPriority;
    private Integer minPriority;
    private String name;
    private String nameLike;
    private String owner;
    private String ownerExpression;
    private Integer priority;
    private Boolean unassigned;
    private Boolean active;
    private Boolean suspended;
    private String caseDefinitionKey;
    private String caseDefinitionId;
    private String caseDefinitionName;
    private String caseDefinitionNameLike;
    private String caseInstanceId;
    private String caseInstanceBusinessKey;
    private String caseInstanceBusinessKeyLike;
    private String caseExecutionId;
    private Date dueAfter;
    private String dueAfterExpression;
    private Date dueBefore;
    private String dueBeforeExpression;
    private Date dueDate;
    private String dueDateExpression;
    private Date followUpAfter;
    private String followUpAfterExpression;
    private Date followUpBefore;
    private String followUpBeforeExpression;
    private Date followUpBeforeOrNotExistent;
    private String followUpBeforeOrNotExistentExpression;
    private Date followUpDate;
    private String followUpDateExpression;
    private Date createdAfter;
    private String createdAfterExpression;
    private Date createdBefore;
    private String createdBeforeExpression;
    private Date createdOn;
    private String createdOnExpression;
    private String delegationState;
    private List<String> candidateGroups;
    private String candidateGroupsExpression;
    private List<VariableQueryParameterDto> taskVariables;
    private List<VariableQueryParameterDto> processVariables;
    private List<VariableQueryParameterDto> caseInstanceVariables;

    public TaskQueryDto() {
    }

    public TaskQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="processInstanceBusinessKey")
    public void setProcessInstanceBusinessKey(String businessKey) {
        this.processInstanceBusinessKey = businessKey;
    }

    @CamundaQueryParam(value="processInstanceBusinessKeyLike")
    public void setProcessInstanceBusinessKeyLike(String businessKeyLike) {
        this.processInstanceBusinessKeyLike = businessKeyLike;
    }

    @CamundaQueryParam(value="processDefinitionKey")
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @CamundaQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @CamundaQueryParam(value="executionId")
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @CamundaQueryParam(value="activityInstanceIdIn", converter=StringArrayConverter.class)
    public void setActivityInstanceIdIn(String[] activityInstanceIdIn) {
        this.activityInstanceIdIn = activityInstanceIdIn;
    }

    @CamundaQueryParam(value="processDefinitionName")
    public void setProcessDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
    }

    @CamundaQueryParam(value="processDefinitionNameLike")
    public void setProcessDefinitionNameLike(String processDefinitionNameLike) {
        this.processDefinitionNameLike = processDefinitionNameLike;
    }

    @CamundaQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @CamundaQueryParam(value="assignee")
    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    @CamundaQueryParam(value="assigneeExpression")
    public void setAssigneeExpression(String assigneeExpression) {
        this.assigneeExpression = assigneeExpression;
    }

    @CamundaQueryParam(value="assigneeLike")
    public void setAssigneeLike(String assigneeLike) {
        this.assigneeLike = assigneeLike;
    }

    @CamundaQueryParam(value="assigneeLikeExpression")
    public void setAssigneeLikeExpression(String assigneeLikeExpression) {
        this.assigneeLikeExpression = assigneeLikeExpression;
    }

    @CamundaQueryParam(value="candidateGroup")
    public void setCandidateGroup(String candidateGroup) {
        this.candidateGroup = candidateGroup;
    }

    @CamundaQueryParam(value="candidateGroupExpression")
    public void setCandidateGroupExpression(String candidateGroupExpression) {
        this.candidateGroupExpression = candidateGroupExpression;
    }

    @CamundaQueryParam(value="candidateUser")
    public void setCandidateUser(String candidateUser) {
        this.candidateUser = candidateUser;
    }

    @CamundaQueryParam(value="candidateUserExpression")
    public void setCandidateUserExpression(String candidateUserExpression) {
        this.candidateUserExpression = candidateUserExpression;
    }

    @CamundaQueryParam(value="taskDefinitionKey")
    public void setTaskDefinitionKey(String taskDefinitionKey) {
        this.taskDefinitionKey = taskDefinitionKey;
    }

    @CamundaQueryParam(value="taskDefinitionKeyLike")
    public void setTaskDefinitionKeyLike(String taskDefinitionKeyLike) {
        this.taskDefinitionKeyLike = taskDefinitionKeyLike;
    }

    @CamundaQueryParam(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @CamundaQueryParam(value="descriptionLike")
    public void setDescriptionLike(String descriptionLike) {
        this.descriptionLike = descriptionLike;
    }

    @CamundaQueryParam(value="involvedUser")
    public void setInvolvedUser(String involvedUser) {
        this.involvedUser = involvedUser;
    }

    @CamundaQueryParam(value="involvedUserExpression")
    public void setInvolvedUserExpression(String involvedUserExpression) {
        this.involvedUserExpression = involvedUserExpression;
    }

    @CamundaQueryParam(value="maxPriority", converter=IntegerConverter.class)
    public void setMaxPriority(Integer maxPriority) {
        this.maxPriority = maxPriority;
    }

    @CamundaQueryParam(value="minPriority", converter=IntegerConverter.class)
    public void setMinPriority(Integer minPriority) {
        this.minPriority = minPriority;
    }

    @CamundaQueryParam(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @CamundaQueryParam(value="nameLike")
    public void setNameLike(String nameLike) {
        this.nameLike = nameLike;
    }

    @CamundaQueryParam(value="owner")
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @CamundaQueryParam(value="ownerExpression")
    public void setOwnerExpression(String ownerExpression) {
        this.ownerExpression = ownerExpression;
    }

    @CamundaQueryParam(value="priority", converter=IntegerConverter.class)
    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    @CamundaQueryParam(value="unassigned", converter=BooleanConverter.class)
    public void setUnassigned(Boolean unassigned) {
        this.unassigned = unassigned;
    }

    @CamundaQueryParam(value="active", converter=BooleanConverter.class)
    public void setActive(Boolean active) {
        this.active = active;
    }

    @CamundaQueryParam(value="suspended", converter=BooleanConverter.class)
    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    @CamundaQueryParam(value="dueAfter", converter=DateConverter.class)
    public void setDueAfter(Date dueAfter) {
        this.dueAfter = dueAfter;
    }

    @CamundaQueryParam(value="dueAfterExpression")
    public void setDueAfterExpression(String dueAfterExpression) {
        this.dueAfterExpression = dueAfterExpression;
    }

    @CamundaQueryParam(value="dueBefore", converter=DateConverter.class)
    public void setDueBefore(Date dueBefore) {
        this.dueBefore = dueBefore;
    }

    @CamundaQueryParam(value="dueBeforeExpression")
    public void setDueBeforeExpression(String dueBeforeExpression) {
        this.dueBeforeExpression = dueBeforeExpression;
    }

    @CamundaQueryParam(value="due", converter=DateConverter.class)
    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    @CamundaQueryParam(value="dueDateExpression")
    public void setDueDateExpression(String dueDateExpression) {
        this.dueDateExpression = dueDateExpression;
    }

    @CamundaQueryParam(value="followUpAfter", converter=DateConverter.class)
    public void setFollowUpAfter(Date followUpAfter) {
        this.followUpAfter = followUpAfter;
    }

    @CamundaQueryParam(value="followUpAfterExpression")
    public void setFollowUpAfterExpression(String followUpAfterExpression) {
        this.followUpAfterExpression = followUpAfterExpression;
    }

    @CamundaQueryParam(value="followUpBefore", converter=DateConverter.class)
    public void setFollowUpBefore(Date followUpBefore) {
        this.followUpBefore = followUpBefore;
    }

    @CamundaQueryParam(value="followUpBeforeOrNotExistentExpression")
    public void setFollowUpBeforeOrNotExistentExpression(String followUpBeforeExpression) {
        this.followUpBeforeOrNotExistentExpression = followUpBeforeExpression;
    }

    @CamundaQueryParam(value="followUpBeforeOrNotExistent", converter=DateConverter.class)
    public void setFollowUpBeforeOrNotExistent(Date followUpBefore) {
        this.followUpBeforeOrNotExistent = followUpBefore;
    }

    @CamundaQueryParam(value="followUpBeforeExpression")
    public void setFollowUpBeforeExpression(String followUpBeforeExpression) {
        this.followUpBeforeExpression = followUpBeforeExpression;
    }

    @CamundaQueryParam(value="followUp", converter=DateConverter.class)
    public void setFollowUpDate(Date followUp) {
        this.followUpDate = followUp;
    }

    @CamundaQueryParam(value="followUpDateExpression")
    public void setFollowUpDateExpression(String followUpDateExpression) {
        this.followUpDateExpression = followUpDateExpression;
    }

    @CamundaQueryParam(value="createdAfter", converter=DateConverter.class)
    public void setCreatedAfter(Date createdAfter) {
        this.createdAfter = createdAfter;
    }

    @CamundaQueryParam(value="createdAfterExpression")
    public void setCreatedAfterExpression(String createdAfterExpression) {
        this.createdAfterExpression = createdAfterExpression;
    }

    @CamundaQueryParam(value="createdBefore", converter=DateConverter.class)
    public void setCreatedBefore(Date createdBefore) {
        this.createdBefore = createdBefore;
    }

    @CamundaQueryParam(value="createdBeforeExpression")
    public void setCreatedBeforeExpression(String createdBeforeExpression) {
        this.createdBeforeExpression = createdBeforeExpression;
    }

    @CamundaQueryParam(value="created", converter=DateConverter.class)
    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    @CamundaQueryParam(value="createdOnExpression")
    public void setCreatedOnExpression(String createdOnExpression) {
        this.createdOnExpression = createdOnExpression;
    }

    @CamundaQueryParam(value="delegationState")
    public void setDelegationState(String taskDelegationState) {
        this.delegationState = taskDelegationState;
    }

    @CamundaQueryParam(value="candidateGroups", converter=StringListConverter.class)
    public void setCandidateGroups(List<String> candidateGroups) {
        this.candidateGroups = candidateGroups;
    }

    @CamundaQueryParam(value="candidateGroupsExpression")
    public void setCandidateGroupsExpression(String candidateGroupsExpression) {
        this.candidateGroupsExpression = candidateGroupsExpression;
    }

    @CamundaQueryParam(value="taskVariables", converter=VariableListConverter.class)
    public void setTaskVariables(List<VariableQueryParameterDto> taskVariables) {
        this.taskVariables = taskVariables;
    }

    @CamundaQueryParam(value="processVariables", converter=VariableListConverter.class)
    public void setProcessVariables(List<VariableQueryParameterDto> processVariables) {
        this.processVariables = processVariables;
    }

    @CamundaQueryParam(value="caseDefinitionId")
    public void setCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    @CamundaQueryParam(value="caseDefinitionKey")
    public void setCaseDefinitionKey(String caseDefinitionKey) {
        this.caseDefinitionKey = caseDefinitionKey;
    }

    @CamundaQueryParam(value="caseDefinitionName")
    public void setCaseDefinitionName(String caseDefinitionName) {
        this.caseDefinitionName = caseDefinitionName;
    }

    @CamundaQueryParam(value="caseDefinitionNameLike")
    public void setCaseDefinitionNameLike(String caseDefinitionNameLike) {
        this.caseDefinitionNameLike = caseDefinitionNameLike;
    }

    @CamundaQueryParam(value="caseExecutionId")
    public void setCaseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
    }

    @CamundaQueryParam(value="caseInstanceBusinessKey")
    public void setCaseInstanceBusinessKey(String caseInstanceBusinessKey) {
        this.caseInstanceBusinessKey = caseInstanceBusinessKey;
    }

    @CamundaQueryParam(value="caseInstanceBusinessKeyLike")
    public void setCaseInstanceBusinessKeyLike(String caseInstanceBusinessKeyLike) {
        this.caseInstanceBusinessKeyLike = caseInstanceBusinessKeyLike;
    }

    @CamundaQueryParam(value="caseInstanceId")
    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @CamundaQueryParam(value="caseInstanceVariables", converter=VariableListConverter.class)
    public void setCaseInstanceVariables(List<VariableQueryParameterDto> caseInstanceVariables) {
        this.caseInstanceVariables = caseInstanceVariables;
    }

    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    protected TaskQuery createNewQuery(ProcessEngine engine) {
        return engine.getTaskService().createTaskQuery();
    }

    public String getProcessInstanceBusinessKey() {
        return this.processInstanceBusinessKey;
    }

    public String getProcessInstanceBusinessKeyLike() {
        return this.processInstanceBusinessKeyLike;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String[] getActivityInstanceIdIn() {
        return this.activityInstanceIdIn;
    }

    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    public String getProcessDefinitionNameLike() {
        return this.processDefinitionNameLike;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public String getAssigneeExpression() {
        return this.assigneeExpression;
    }

    public String getAssigneeLike() {
        return this.assigneeLike;
    }

    public String getAssigneeLikeExpression() {
        return this.assigneeLikeExpression;
    }

    public String getCandidateGroup() {
        return this.candidateGroup;
    }

    public String getCandidateGroupExpression() {
        return this.candidateGroupExpression;
    }

    public String getCandidateUser() {
        return this.candidateUser;
    }

    public String getCandidateUserExpression() {
        return this.candidateUserExpression;
    }

    public String getTaskDefinitionKey() {
        return this.taskDefinitionKey;
    }

    public String getTaskDefinitionKeyLike() {
        return this.taskDefinitionKeyLike;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescriptionLike() {
        return this.descriptionLike;
    }

    public String getInvolvedUser() {
        return this.involvedUser;
    }

    public String getInvolvedUserExpression() {
        return this.involvedUserExpression;
    }

    public Integer getMaxPriority() {
        return this.maxPriority;
    }

    public Integer getMinPriority() {
        return this.minPriority;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getOwnerExpression() {
        return this.ownerExpression;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public Boolean getUnassigned() {
        return this.unassigned;
    }

    public Boolean getActive() {
        return this.active;
    }

    public Boolean getSuspended() {
        return this.suspended;
    }

    public String getCaseDefinitionKey() {
        return this.caseDefinitionKey;
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public String getCaseDefinitionName() {
        return this.caseDefinitionName;
    }

    public String getCaseDefinitionNameLike() {
        return this.caseDefinitionNameLike;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public String getCaseInstanceBusinessKey() {
        return this.caseInstanceBusinessKey;
    }

    public String getCaseInstanceBusinessKeyLike() {
        return this.caseInstanceBusinessKeyLike;
    }

    public String getCaseExecutionId() {
        return this.caseExecutionId;
    }

    public Date getDueAfter() {
        return this.dueAfter;
    }

    public String getDueAfterExpression() {
        return this.dueAfterExpression;
    }

    public Date getDueBefore() {
        return this.dueBefore;
    }

    public String getDueBeforeExpression() {
        return this.dueBeforeExpression;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public String getDueDateExpression() {
        return this.dueDateExpression;
    }

    public Date getFollowUpAfter() {
        return this.followUpAfter;
    }

    public String getFollowUpAfterExpression() {
        return this.followUpAfterExpression;
    }

    public Date getFollowUpBefore() {
        return this.followUpBefore;
    }

    public String getFollowUpBeforeExpression() {
        return this.followUpBeforeExpression;
    }

    public Date getFollowUpBeforeOrNotExistent() {
        return this.followUpBeforeOrNotExistent;
    }

    public String getFollowUpBeforeOrNotExistentExpression() {
        return this.followUpBeforeOrNotExistentExpression;
    }

    public Date getFollowUpDate() {
        return this.followUpDate;
    }

    public String getFollowUpDateExpression() {
        return this.followUpDateExpression;
    }

    public Date getCreatedAfter() {
        return this.createdAfter;
    }

    public String getCreatedAfterExpression() {
        return this.createdAfterExpression;
    }

    public Date getCreatedBefore() {
        return this.createdBefore;
    }

    public String getCreatedBeforeExpression() {
        return this.createdBeforeExpression;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public String getCreatedOnExpression() {
        return this.createdOnExpression;
    }

    public String getDelegationState() {
        return this.delegationState;
    }

    public List<String> getCandidateGroups() {
        return this.candidateGroups;
    }

    public String getCandidateGroupsExpression() {
        return this.candidateGroupsExpression;
    }

    public List<VariableQueryParameterDto> getTaskVariables() {
        return this.taskVariables;
    }

    public List<VariableQueryParameterDto> getProcessVariables() {
        return this.processVariables;
    }

    public List<VariableQueryParameterDto> getCaseInstanceVariables() {
        return this.caseInstanceVariables;
    }

    protected void applyFilters(TaskQuery query) {
        Object variableValue;
        String op;
        String variableName;
        if (this.processInstanceBusinessKey != null) {
            query.processInstanceBusinessKey(this.processInstanceBusinessKey);
        }
        if (this.processInstanceBusinessKeyLike != null) {
            query.processInstanceBusinessKeyLike(this.processInstanceBusinessKeyLike);
        }
        if (this.processDefinitionKey != null) {
            query.processDefinitionKey(this.processDefinitionKey);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.executionId != null) {
            query.executionId(this.executionId);
        }
        if (this.activityInstanceIdIn != null && this.activityInstanceIdIn.length > 0) {
            query.activityInstanceIdIn(this.activityInstanceIdIn);
        }
        if (this.processDefinitionName != null) {
            query.processDefinitionName(this.processDefinitionName);
        }
        if (this.processDefinitionNameLike != null) {
            query.processDefinitionNameLike(this.processDefinitionNameLike);
        }
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.assignee != null) {
            query.taskAssignee(this.assignee);
        }
        if (this.assigneeExpression != null) {
            query.taskAssigneeExpression(this.assigneeExpression);
        }
        if (this.assigneeLike != null) {
            query.taskAssigneeLike(this.assigneeLike);
        }
        if (this.assigneeLikeExpression != null) {
            query.taskAssigneeLikeExpression(this.assigneeLikeExpression);
        }
        if (this.candidateGroup != null) {
            query.taskCandidateGroup(this.candidateGroup);
        }
        if (this.candidateGroupExpression != null) {
            query.taskCandidateGroupExpression(this.candidateGroupExpression);
        }
        if (this.candidateUser != null) {
            query.taskCandidateUser(this.candidateUser);
        }
        if (this.candidateUserExpression != null) {
            query.taskCandidateUserExpression(this.candidateUserExpression);
        }
        if (this.taskDefinitionKey != null) {
            query.taskDefinitionKey(this.taskDefinitionKey);
        }
        if (this.taskDefinitionKeyLike != null) {
            query.taskDefinitionKeyLike(this.taskDefinitionKeyLike);
        }
        if (this.description != null) {
            query.taskDescription(this.description);
        }
        if (this.descriptionLike != null) {
            query.taskDescriptionLike(this.descriptionLike);
        }
        if (this.involvedUser != null) {
            query.taskInvolvedUser(this.involvedUser);
        }
        if (this.involvedUserExpression != null) {
            query.taskInvolvedUserExpression(this.involvedUserExpression);
        }
        if (this.maxPriority != null) {
            query.taskMaxPriority(this.maxPriority);
        }
        if (this.minPriority != null) {
            query.taskMinPriority(this.minPriority);
        }
        if (this.name != null) {
            query.taskName(this.name);
        }
        if (this.nameLike != null) {
            query.taskNameLike(this.nameLike);
        }
        if (this.owner != null) {
            query.taskOwner(this.owner);
        }
        if (this.ownerExpression != null) {
            query.taskOwnerExpression(this.ownerExpression);
        }
        if (this.priority != null) {
            query.taskPriority(this.priority);
        }
        if (this.unassigned != null && this.unassigned.booleanValue()) {
            query.taskUnassigned();
        }
        if (this.dueAfter != null) {
            query.dueAfter(this.dueAfter);
        }
        if (this.dueAfterExpression != null) {
            query.dueAfterExpression(this.dueAfterExpression);
        }
        if (this.dueBefore != null) {
            query.dueBefore(this.dueBefore);
        }
        if (this.dueBeforeExpression != null) {
            query.dueBeforeExpression(this.dueBeforeExpression);
        }
        if (this.dueDate != null) {
            query.dueDate(this.dueDate);
        }
        if (this.dueDateExpression != null) {
            query.dueDateExpression(this.dueDateExpression);
        }
        if (this.followUpAfter != null) {
            query.followUpAfter(this.followUpAfter);
        }
        if (this.followUpAfterExpression != null) {
            query.followUpAfterExpression(this.followUpAfterExpression);
        }
        if (this.followUpBefore != null) {
            query.followUpBefore(this.followUpBefore);
        }
        if (this.followUpBeforeExpression != null) {
            query.followUpBeforeExpression(this.followUpBeforeExpression);
        }
        if (this.followUpBeforeOrNotExistent != null) {
            query.followUpBeforeOrNotExistent(this.followUpBeforeOrNotExistent);
        }
        if (this.followUpBeforeOrNotExistentExpression != null) {
            query.followUpBeforeOrNotExistentExpression(this.followUpBeforeOrNotExistentExpression);
        }
        if (this.followUpDate != null) {
            query.followUpDate(this.followUpDate);
        }
        if (this.followUpDateExpression != null) {
            query.followUpDateExpression(this.followUpDateExpression);
        }
        if (this.createdAfter != null) {
            query.taskCreatedAfter(this.createdAfter);
        }
        if (this.createdAfterExpression != null) {
            query.taskCreatedAfterExpression(this.createdAfterExpression);
        }
        if (this.createdBefore != null) {
            query.taskCreatedBefore(this.createdBefore);
        }
        if (this.createdBeforeExpression != null) {
            query.taskCreatedBeforeExpression(this.createdBeforeExpression);
        }
        if (this.createdOn != null) {
            query.taskCreatedOn(this.createdOn);
        }
        if (this.createdOnExpression != null) {
            query.taskCreatedOnExpression(this.createdOnExpression);
        }
        if (this.delegationState != null) {
            DelegationStateConverter converter = new DelegationStateConverter();
            DelegationState state = converter.convertQueryParameterToType(this.delegationState);
            query.taskDelegationState(state);
        }
        if (this.candidateGroups != null) {
            query.taskCandidateGroupIn(this.candidateGroups);
        }
        if (this.candidateGroupsExpression != null) {
            query.taskCandidateGroupInExpression(this.candidateGroupsExpression);
        }
        if (this.active != null && this.active.booleanValue()) {
            query.active();
        }
        if (this.suspended != null && this.suspended.booleanValue()) {
            query.suspended();
        }
        if (this.caseDefinitionId != null) {
            query.caseDefinitionId(this.caseDefinitionId);
        }
        if (this.caseDefinitionKey != null) {
            query.caseDefinitionKey(this.caseDefinitionKey);
        }
        if (this.caseDefinitionName != null) {
            query.caseDefinitionName(this.caseDefinitionName);
        }
        if (this.caseDefinitionNameLike != null) {
            query.caseDefinitionNameLike(this.caseDefinitionNameLike);
        }
        if (this.caseExecutionId != null) {
            query.caseExecutionId(this.caseExecutionId);
        }
        if (this.caseInstanceBusinessKey != null) {
            query.caseInstanceBusinessKey(this.caseInstanceBusinessKey);
        }
        if (this.caseInstanceBusinessKeyLike != null) {
            query.caseInstanceBusinessKeyLike(this.caseInstanceBusinessKeyLike);
        }
        if (this.caseInstanceId != null) {
            query.caseInstanceId(this.caseInstanceId);
        }
        if (this.taskVariables != null) {
            for (VariableQueryParameterDto variableQueryParam : this.taskVariables) {
                variableName = variableQueryParam.getName();
                op = variableQueryParam.getOperator();
                variableValue = variableQueryParam.resolveValue(this.objectMapper);
                if (op.equals("eq")) {
                    query.taskVariableValueEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("neq")) {
                    query.taskVariableValueNotEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("gt")) {
                    query.taskVariableValueGreaterThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("gteq")) {
                    query.taskVariableValueGreaterThanOrEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("lt")) {
                    query.taskVariableValueLessThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("lteq")) {
                    query.taskVariableValueLessThanOrEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("like")) {
                    query.taskVariableValueLike(variableName, String.valueOf(variableValue));
                    continue;
                }
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Invalid task variable comparator specified: " + op);
            }
        }
        if (this.processVariables != null) {
            for (VariableQueryParameterDto variableQueryParam : this.processVariables) {
                variableName = variableQueryParam.getName();
                op = variableQueryParam.getOperator();
                variableValue = variableQueryParam.resolveValue(this.objectMapper);
                if (op.equals("eq")) {
                    query.processVariableValueEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("neq")) {
                    query.processVariableValueNotEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("gt")) {
                    query.processVariableValueGreaterThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("gteq")) {
                    query.processVariableValueGreaterThanOrEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("lt")) {
                    query.processVariableValueLessThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("lteq")) {
                    query.processVariableValueLessThanOrEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("like")) {
                    query.processVariableValueLike(variableName, String.valueOf(variableValue));
                    continue;
                }
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Invalid process variable comparator specified: " + op);
            }
        }
        if (this.caseInstanceVariables != null) {
            for (VariableQueryParameterDto variableQueryParam : this.caseInstanceVariables) {
                variableName = variableQueryParam.getName();
                op = variableQueryParam.getOperator();
                variableValue = variableQueryParam.resolveValue(this.objectMapper);
                if (op.equals("eq")) {
                    query.caseInstanceVariableValueEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("neq")) {
                    query.caseInstanceVariableValueNotEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("gt")) {
                    query.caseInstanceVariableValueGreaterThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("gteq")) {
                    query.caseInstanceVariableValueGreaterThanOrEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("lt")) {
                    query.caseInstanceVariableValueLessThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("lteq")) {
                    query.caseInstanceVariableValueLessThanOrEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("like")) {
                    query.caseInstanceVariableValueLike(variableName, String.valueOf(variableValue));
                    continue;
                }
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Invalid case variable comparator specified: " + op);
            }
        }
    }

    protected void applySortingOptions(TaskQuery query) {
        if (this.sortBy != null) {
            if (this.sortBy.equals(SORT_BY_PROCESS_INSTANCE_ID_VALUE)) {
                query.orderByProcessInstanceId();
            } else if (this.sortBy.equals(SORT_BY_CASE_INSTANCE_ID_VALUE)) {
                query.orderByCaseInstanceId();
            } else if (this.sortBy.equals(SORT_BY_DUE_DATE_VALUE)) {
                query.orderByDueDate();
            } else if (this.sortBy.equals(SORT_BY_FOLLOW_UP_VALUE)) {
                query.orderByFollowUpDate();
            } else if (this.sortBy.equals(SORT_BY_EXECUTION_ID_VALUE)) {
                query.orderByExecutionId();
            } else if (this.sortBy.equals(SORT_BY_CASE_EXECUTION_ID_VALUE)) {
                query.orderByCaseExecutionId();
            } else if (this.sortBy.equals(SORT_BY_ASSIGNEE_VALUE)) {
                query.orderByTaskAssignee();
            } else if (this.sortBy.equals(SORT_BY_CREATE_TIME_VALUE)) {
                query.orderByTaskCreateTime();
            } else if (this.sortBy.equals(SORT_BY_DESCRIPTION_VALUE)) {
                query.orderByTaskDescription();
            } else if (this.sortBy.equals(SORT_BY_ID_VALUE)) {
                query.orderByTaskId();
            } else if (this.sortBy.equals(SORT_BY_NAME_VALUE)) {
                query.orderByTaskName();
            } else if (this.sortBy.equals(SORT_BY_NAME_CASE_INSENSITIVE_VALUE)) {
                query.orderByTaskNameCaseInsensitive();
            } else if (this.sortBy.equals(SORT_BY_PRIORITY_VALUE)) {
                query.orderByTaskPriority();
            }
        }
        if (this.sortOrder != null) {
            if (this.sortOrder.equals("asc")) {
                query.asc();
            } else if (this.sortOrder.equals("desc")) {
                query.desc();
            }
        }
    }

    public static TaskQueryDto fromQuery(Query<?, ?> query) {
        Map expressions;
        TaskQueryImpl taskQuery = (TaskQueryImpl)query;
        TaskQueryDto dto = new TaskQueryDto();
        dto.activityInstanceIdIn = taskQuery.getActivityInstanceIdIn();
        dto.assignee = taskQuery.getAssignee();
        dto.assigneeLike = taskQuery.getAssigneeLike();
        dto.caseDefinitionId = taskQuery.getCaseDefinitionId();
        dto.caseDefinitionKey = taskQuery.getCaseDefinitionKey();
        dto.caseDefinitionName = taskQuery.getCaseDefinitionName();
        dto.caseDefinitionNameLike = taskQuery.getCaseDefinitionNameLike();
        dto.caseExecutionId = taskQuery.getCaseExecutionId();
        dto.caseInstanceBusinessKey = taskQuery.getCaseInstanceBusinessKey();
        dto.caseInstanceBusinessKeyLike = taskQuery.getCaseInstanceBusinessKeyLike();
        dto.caseInstanceId = taskQuery.getCaseInstanceId();
        dto.candidateUser = taskQuery.getCandidateUser();
        dto.candidateGroup = taskQuery.getCandidateGroup();
        dto.candidateGroups = taskQuery.getCandidateGroupsInternal();
        dto.processInstanceBusinessKey = taskQuery.getProcessInstanceBusinessKey();
        dto.processInstanceBusinessKeyLike = taskQuery.getProcessInstanceBusinessKeyLike();
        dto.processDefinitionKey = taskQuery.getProcessDefinitionKey();
        dto.processDefinitionId = taskQuery.getProcessDefinitionId();
        dto.executionId = taskQuery.getExecutionId();
        dto.activityInstanceIdIn = taskQuery.getActivityInstanceIdIn();
        dto.processDefinitionName = taskQuery.getProcessDefinitionName();
        dto.processDefinitionNameLike = taskQuery.getProcessDefinitionNameLike();
        dto.processInstanceId = taskQuery.getProcessInstanceId();
        dto.assignee = taskQuery.getAssignee();
        dto.assigneeLike = taskQuery.getAssigneeLike();
        dto.taskDefinitionKey = taskQuery.getKey();
        dto.taskDefinitionKeyLike = taskQuery.getKeyLike();
        dto.description = taskQuery.getDescription();
        dto.descriptionLike = taskQuery.getDescriptionLike();
        dto.involvedUser = taskQuery.getInvolvedUser();
        dto.maxPriority = taskQuery.getMaxPriority();
        dto.minPriority = taskQuery.getMinPriority();
        dto.name = taskQuery.getName();
        dto.nameLike = taskQuery.getNameLike();
        dto.owner = taskQuery.getOwner();
        dto.priority = taskQuery.getPriority();
        dto.unassigned = taskQuery.isUnassignedInternal();
        dto.dueAfter = taskQuery.getDueAfter();
        dto.dueBefore = taskQuery.getDueBefore();
        dto.dueDate = taskQuery.getDueDate();
        dto.followUpAfter = taskQuery.getFollowUpAfter();
        if (taskQuery.isFollowUpNullAccepted()) {
            dto.followUpBeforeOrNotExistent = taskQuery.getFollowUpBefore();
        } else {
            dto.followUpBefore = taskQuery.getFollowUpBefore();
        }
        dto.followUpDate = taskQuery.getFollowUpDate();
        dto.createdAfter = taskQuery.getCreateTimeAfter();
        dto.createdBefore = taskQuery.getCreateTimeBefore();
        dto.createdOn = taskQuery.getCreateTime();
        if (taskQuery.getDelegationState() != null) {
            dto.delegationState = taskQuery.getDelegationState().toString();
        }
        dto.processVariables = new ArrayList();
        dto.taskVariables = new ArrayList();
        dto.caseInstanceVariables = new ArrayList();
        for (TaskQueryVariableValue variableValue : taskQuery.getVariables()) {
            VariableQueryParameterDto variableValueDto = new VariableQueryParameterDto(variableValue);
            if (variableValue.isProcessInstanceVariable()) {
                dto.processVariables.add(variableValueDto);
                continue;
            }
            if (variableValue.isLocal()) {
                dto.taskVariables.add(variableValueDto);
                continue;
            }
            dto.caseInstanceVariables.add(variableValueDto);
        }
        if (taskQuery.getSuspensionState() == SuspensionState.ACTIVE) {
            dto.active = true;
        }
        if (taskQuery.getSuspensionState() == SuspensionState.SUSPENDED) {
            dto.suspended = true;
        }
        if ((expressions = taskQuery.getExpressions()).containsKey("taskAssignee")) {
            dto.setAssigneeExpression((String)expressions.get("taskAssignee"));
        }
        if (expressions.containsKey("taskAssigneeLike")) {
            dto.setAssigneeLikeExpression((String)expressions.get("taskAssigneeLike"));
        }
        if (expressions.containsKey("taskOwner")) {
            dto.setOwnerExpression((String)expressions.get("taskOwner"));
        }
        if (expressions.containsKey("taskCandidateUser")) {
            dto.setCandidateUserExpression((String)expressions.get("taskCandidateUser"));
        }
        if (expressions.containsKey("taskInvolvedUser")) {
            dto.setInvolvedUserExpression((String)expressions.get("taskInvolvedUser"));
        }
        if (expressions.containsKey("taskCandidateGroup")) {
            dto.setCandidateGroupExpression((String)expressions.get("taskCandidateGroup"));
        }
        if (expressions.containsKey("taskCandidateGroupIn")) {
            dto.setCandidateGroupsExpression((String)expressions.get("taskCandidateGroupIn"));
        }
        if (expressions.containsKey("taskCreatedOne")) {
            dto.setCreatedOnExpression((String)expressions.get("taskCreatedOne"));
        }
        if (expressions.containsKey("taskCreatedBefore")) {
            dto.setCreatedBeforeExpression((String)expressions.get("taskCreatedBefore"));
        }
        if (expressions.containsKey("taskCreatedAfter")) {
            dto.setCreatedAfterExpression((String)expressions.get("taskCreatedAfter"));
        }
        if (expressions.containsKey(SORT_BY_DUE_DATE_VALUE)) {
            dto.setDueDateExpression((String)expressions.get(SORT_BY_DUE_DATE_VALUE));
        }
        if (expressions.containsKey("dueBefore")) {
            dto.setDueBeforeExpression((String)expressions.get("dueBefore"));
        }
        if (expressions.containsKey("dueAfter")) {
            dto.setDueAfterExpression((String)expressions.get("dueAfter"));
        }
        if (expressions.containsKey(SORT_BY_FOLLOW_UP_VALUE)) {
            dto.setFollowUpDateExpression((String)expressions.get(SORT_BY_FOLLOW_UP_VALUE));
        }
        if (expressions.containsKey("followUpBefore")) {
            dto.setFollowUpBeforeExpression((String)expressions.get("followUpBefore"));
        }
        if (expressions.containsKey("followUpBeforeOrNotExistent")) {
            dto.setFollowUpBeforeOrNotExistentExpression((String)expressions.get("followUpBeforeOrNotExistent"));
        }
        if (expressions.containsKey("followUpAfter")) {
            dto.setFollowUpAfterExpression((String)expressions.get("followUpAfter"));
        }
        return dto;
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_CASE_INSTANCE_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_DUE_DATE_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_FOLLOW_UP_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_EXECUTION_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_CASE_EXECUTION_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_ASSIGNEE_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_CREATE_TIME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_DESCRIPTION_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_NAME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_NAME_CASE_INSENSITIVE_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PRIORITY_VALUE);
    }
}

