/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl.history;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricActivityInstanceQuery;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricActivityInstanceDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricActivityInstanceQueryDto;
import org.camunda.bpm.engine.rest.history.HistoricActivityInstanceRestService;
import org.camunda.bpm.engine.rest.sub.history.HistoricActivityInstanceResource;
import org.camunda.bpm.engine.rest.sub.history.impl.HistoricActivityInstanceResourceImpl;
import org.codehaus.jackson.map.ObjectMapper;

public class HistoricActivityInstanceRestServiceImpl
implements HistoricActivityInstanceRestService {
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public HistoricActivityInstanceRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    public HistoricActivityInstanceResource getHistoricCaseInstance(String activityInstanceId) {
        return new HistoricActivityInstanceResourceImpl(this.processEngine, activityInstanceId);
    }

    public List<HistoricActivityInstanceDto> getHistoricActivityInstances(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        HistoricActivityInstanceQueryDto queryHistoricActivityInstanceDto = new HistoricActivityInstanceQueryDto(this.objectMapper, uriInfo.getQueryParameters());
        return this.queryHistoricActivityInstances(queryHistoricActivityInstanceDto, firstResult, maxResults);
    }

    public List<HistoricActivityInstanceDto> queryHistoricActivityInstances(HistoricActivityInstanceQueryDto queryDto, Integer firstResult, Integer maxResults) {
        queryDto.setObjectMapper(this.objectMapper);
        HistoricActivityInstanceQuery query = (HistoricActivityInstanceQuery)queryDto.toQuery(this.processEngine);
        List matchingHistoricActivityInstances = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        ArrayList<HistoricActivityInstanceDto> historicActivityInstanceResults = new ArrayList<HistoricActivityInstanceDto>();
        for (HistoricActivityInstance historicActivityInstance : matchingHistoricActivityInstances) {
            HistoricActivityInstanceDto resultHistoricActivityInstance = HistoricActivityInstanceDto.fromHistoricActivityInstance((HistoricActivityInstance)historicActivityInstance);
            historicActivityInstanceResults.add(resultHistoricActivityInstance);
        }
        return historicActivityInstanceResults;
    }

    private List<HistoricActivityInstance> executePaginatedQuery(HistoricActivityInstanceQuery query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }

    public CountResultDto getHistoricActivityInstancesCount(UriInfo uriInfo) {
        HistoricActivityInstanceQueryDto queryDto = new HistoricActivityInstanceQueryDto(this.objectMapper, uriInfo.getQueryParameters());
        return this.queryHistoricActivityInstancesCount(queryDto);
    }

    public CountResultDto queryHistoricActivityInstancesCount(HistoricActivityInstanceQueryDto queryDto) {
        queryDto.setObjectMapper(this.objectMapper);
        HistoricActivityInstanceQuery query = (HistoricActivityInstanceQuery)queryDto.toQuery(this.processEngine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

