/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.repository.impl;

import java.io.Closeable;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.form.FormData;
import org.camunda.bpm.engine.form.StartFormData;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.management.ActivityStatistics;
import org.camunda.bpm.engine.management.ActivityStatisticsQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.rest.dto.StatisticsResultDto;
import org.camunda.bpm.engine.rest.dto.VariableValueDto;
import org.camunda.bpm.engine.rest.dto.converter.StringListConverter;
import org.camunda.bpm.engine.rest.dto.repository.ActivityStatisticsResultDto;
import org.camunda.bpm.engine.rest.dto.repository.ProcessDefinitionDiagramDto;
import org.camunda.bpm.engine.rest.dto.repository.ProcessDefinitionDto;
import org.camunda.bpm.engine.rest.dto.repository.ProcessDefinitionSuspensionStateDto;
import org.camunda.bpm.engine.rest.dto.runtime.ProcessInstanceDto;
import org.camunda.bpm.engine.rest.dto.runtime.StartProcessInstanceDto;
import org.camunda.bpm.engine.rest.dto.task.FormDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.sub.repository.ProcessDefinitionResource;
import org.camunda.bpm.engine.rest.util.ApplicationContextPathUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.variable.VariableMap;
import org.codehaus.jackson.map.ObjectMapper;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProcessDefinitionResourceImpl
implements ProcessDefinitionResource {
    protected ProcessEngine engine;
    protected String processDefinitionId;
    protected String rootResourcePath;
    protected ObjectMapper objectMapper;

    public ProcessDefinitionResourceImpl(ProcessEngine engine, String processDefinitionId, String rootResourcePath, ObjectMapper objectMapper) {
        this.engine = engine;
        this.processDefinitionId = processDefinitionId;
        this.rootResourcePath = rootResourcePath;
        this.objectMapper = objectMapper;
    }

    public ProcessDefinitionDto getProcessDefinition() {
        ProcessDefinition definition;
        RepositoryService repoService = this.engine.getRepositoryService();
        try {
            definition = repoService.getProcessDefinition(this.processDefinitionId);
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, (Exception)((Object)e), "No matching definition with id " + this.processDefinitionId);
        }
        ProcessDefinitionDto result = ProcessDefinitionDto.fromProcessDefinition((ProcessDefinition)definition);
        return result;
    }

    public ProcessInstanceDto startProcessInstance(UriInfo context, StartProcessInstanceDto parameters) {
        RuntimeService runtimeService = this.engine.getRuntimeService();
        ProcessInstance instance = null;
        try {
            VariableMap variables = VariableValueDto.toMap((Map)parameters.getVariables(), (ProcessEngine)this.engine, (ObjectMapper)this.objectMapper);
            String businessKey = parameters.getBusinessKey();
            String caseInstanceId = parameters.getCaseInstanceId();
            instance = runtimeService.startProcessInstanceById(this.processDefinitionId, businessKey, caseInstanceId, (Map)variables);
        }
        catch (ProcessEngineException e) {
            String errorMessage = String.format("Cannot instantiate process definition %s: %s", this.processDefinitionId, e.getMessage());
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), errorMessage);
        }
        catch (RestException e) {
            String errorMessage = String.format("Cannot instantiate process definition %s: %s", this.processDefinitionId, e.getMessage());
            throw new InvalidRequestException(e.getStatus(), (Exception)((Object)e), errorMessage);
        }
        ProcessInstanceDto result = ProcessInstanceDto.fromProcessInstance((ProcessInstance)instance);
        URI uri = context.getBaseUriBuilder().path(this.rootResourcePath).path("/process-instance").path(instance.getId()).build(new Object[0]);
        result.addReflexiveLink(uri, "GET", "self");
        return result;
    }

    public ProcessInstanceDto submitForm(UriInfo context, StartProcessInstanceDto parameters) {
        FormService formService = this.engine.getFormService();
        ProcessInstance instance = null;
        try {
            VariableMap variables = VariableValueDto.toMap((Map)parameters.getVariables(), (ProcessEngine)this.engine, (ObjectMapper)this.objectMapper);
            String businessKey = parameters.getBusinessKey();
            instance = businessKey != null ? formService.submitStartForm(this.processDefinitionId, businessKey, (Map)variables) : formService.submitStartForm(this.processDefinitionId, (Map)variables);
        }
        catch (ProcessEngineException e) {
            String errorMessage = String.format("Cannot instantiate process definition %s: %s", this.processDefinitionId, e.getMessage());
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), errorMessage);
        }
        catch (RestException e) {
            String errorMessage = String.format("Cannot instantiate process definition %s: %s", this.processDefinitionId, e.getMessage());
            throw new InvalidRequestException(e.getStatus(), (Exception)((Object)e), errorMessage);
        }
        ProcessInstanceDto result = ProcessInstanceDto.fromProcessInstance((ProcessInstance)instance);
        URI uri = context.getBaseUriBuilder().path(this.rootResourcePath).path("/process-instance").path(instance.getId()).build(new Object[0]);
        result.addReflexiveLink(uri, "GET", "self");
        return result;
    }

    public List<StatisticsResultDto> getActivityStatistics(Boolean includeFailedJobs, Boolean includeIncidents, String includeIncidentsForType) {
        if (includeIncidents != null && includeIncidentsForType != null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Only one of the query parameter includeIncidents or includeIncidentsForType can be set.");
        }
        ManagementService mgmtService = this.engine.getManagementService();
        ActivityStatisticsQuery query = mgmtService.createActivityStatisticsQuery(this.processDefinitionId);
        if (includeFailedJobs != null && includeFailedJobs.booleanValue()) {
            query.includeFailedJobs();
        }
        if (includeIncidents != null && includeIncidents.booleanValue()) {
            query.includeIncidents();
        } else if (includeIncidentsForType != null) {
            query.includeIncidentsForType(includeIncidentsForType);
        }
        List queryResults = query.list();
        ArrayList<StatisticsResultDto> results = new ArrayList<StatisticsResultDto>();
        for (ActivityStatistics queryResult : queryResults) {
            ActivityStatisticsResultDto dto = ActivityStatisticsResultDto.fromActivityStatistics((ActivityStatistics)queryResult);
            results.add((StatisticsResultDto)dto);
        }
        return results;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ProcessDefinitionDiagramDto getProcessDefinitionBpmn20Xml() {
        ProcessDefinitionDiagramDto processDefinitionDiagramDto;
        InputStream processModelIn = null;
        try {
            processModelIn = this.engine.getRepositoryService().getProcessModel(this.processDefinitionId);
            byte[] processModel = IoUtil.readInputStream((InputStream)processModelIn, (String)"processModelBpmn20Xml");
            processDefinitionDiagramDto = ProcessDefinitionDiagramDto.create((String)this.processDefinitionId, (String)new String(processModel, "UTF-8"));
        }
        catch (ProcessEngineException e) {
            try {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), "No matching definition with id " + this.processDefinitionId);
                catch (UnsupportedEncodingException e2) {
                    throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)e2);
                }
            }
            catch (Throwable throwable) {
                IoUtil.closeSilently(processModelIn);
                throw throwable;
            }
        }
        IoUtil.closeSilently((Closeable)processModelIn);
        return processDefinitionDiagramDto;
    }

    public Response getProcessDefinitionDiagram() {
        ProcessDefinition definition = this.engine.getRepositoryService().getProcessDefinition(this.processDefinitionId);
        InputStream processDiagram = this.engine.getRepositoryService().getProcessDiagram(this.processDefinitionId);
        if (processDiagram == null) {
            return Response.noContent().build();
        }
        String fileName = definition.getDiagramResourceName();
        return Response.ok((Object)processDiagram).header("Content-Disposition", (Object)("attachment; filename=" + fileName)).type(ProcessDefinitionResourceImpl.getMediaTypeForFileSuffix((String)fileName)).build();
    }

    public static String getMediaTypeForFileSuffix(String fileName) {
        String mediaType = "application/octet-stream";
        if (fileName != null) {
            if ((fileName = fileName.toLowerCase()).endsWith(".png")) {
                mediaType = "image/png";
            } else if (fileName.endsWith(".svg")) {
                mediaType = "image/svg+xml";
            } else if (fileName.endsWith(".jpg") || fileName.endsWith(".jpeg")) {
                mediaType = "image/jpeg";
            } else if (fileName.endsWith(".gif")) {
                mediaType = "image/gif";
            } else if (fileName.endsWith(".bmp")) {
                mediaType = "image/bmp";
            }
        }
        return mediaType;
    }

    public FormDto getStartForm() {
        StartFormData formData;
        FormService formService = this.engine.getFormService();
        try {
            formData = formService.getStartFormData(this.processDefinitionId);
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), "Cannot get start form data for process definition " + this.processDefinitionId);
        }
        FormDto dto = FormDto.fromFormData((FormData)formData);
        if ((dto.getKey() == null || dto.getKey().isEmpty()) && formData != null && formData.getFormFields() != null && !formData.getFormFields().isEmpty()) {
            dto.setKey("embedded:engine://engine/:engine/process-definition/" + this.processDefinitionId + "/rendered-form");
        }
        dto.setContextPath(ApplicationContextPathUtil.getApplicationPathByProcessDefinitionId((ProcessEngine)this.engine, (String)this.processDefinitionId));
        return dto;
    }

    public String getRenderedForm() {
        FormService formService = this.engine.getFormService();
        Object startForm = formService.getRenderedStartForm(this.processDefinitionId);
        if (startForm != null) {
            return startForm.toString();
        }
        throw new InvalidRequestException(Response.Status.NOT_FOUND, "No matching rendered start form for process definition with the id " + this.processDefinitionId + " found.");
    }

    public void updateSuspensionState(ProcessDefinitionSuspensionStateDto dto) {
        try {
            dto.setProcessDefinitionId(this.processDefinitionId);
            dto.updateSuspensionState(this.engine);
        }
        catch (IllegalArgumentException e) {
            String message = String.format("The suspension state of Process Definition with id %s could not be updated due to: %s", this.processDefinitionId, e.getMessage());
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)e, message);
        }
    }

    public Map<String, VariableValueDto> getFormVariables(String variableNames, boolean deserializeValues) {
        FormService formService = this.engine.getFormService();
        List formVariables = null;
        if (variableNames != null) {
            StringListConverter stringListConverter = new StringListConverter();
            formVariables = stringListConverter.convertQueryParameterToType(variableNames);
        }
        VariableMap startFormVariables = formService.getStartFormVariables(this.processDefinitionId, formVariables, deserializeValues);
        return VariableValueDto.fromVariableMap((VariableMap)startFormVariables);
    }
}

