/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.history;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricIncidentQuery;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.converter.BooleanConverter;
import org.codehaus.jackson.map.ObjectMapper;

public class HistoricIncidentQueryDto
extends AbstractQueryDto<HistoricIncidentQuery> {
    private static final String SORT_BY_INCIDENT_ID = "incidentId";
    private static final String SORT_BY_CREATE_TIME = "createTime";
    private static final String SORT_BY_END_TIME = "endTime";
    private static final String SORT_BY_INCIDENT_TYPE = "incidentType";
    private static final String SORT_BY_EXECUTION_ID = "executionId";
    private static final String SORT_BY_ACTIVITY_ID = "activityId";
    private static final String SORT_BY_PROCESS_INSTANCE_ID = "processInstanceId";
    private static final String SORT_BY_PROCESS_DEFINITION_ID = "processDefinitionId";
    private static final String SORT_BY_CAUSE_INCIDENT_ID = "causeIncidentId";
    private static final String SORT_BY_ROOT_CAUSE_INCIDENT_ID = "rootCauseIncidentId";
    private static final String SORT_BY_CONFIGURATION = "configuration";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList();
    protected String incidentId;
    protected String incidentType;
    protected String incidentMessage;
    protected String processDefinitionId;
    protected String processInstanceId;
    protected String executionId;
    protected String activityId;
    protected String causeIncidentId;
    protected String rootCauseIncidentId;
    protected String configuration;
    protected Boolean open;
    protected Boolean resolved;
    protected Boolean deleted;

    public HistoricIncidentQueryDto() {
    }

    public HistoricIncidentQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="incidentId")
    public void setIncidentId(String incidentId) {
        this.incidentId = incidentId;
    }

    @CamundaQueryParam(value="incidentType")
    public void setIncidentType(String incidentType) {
        this.incidentType = incidentType;
    }

    @CamundaQueryParam(value="incidentMessage")
    public void setIncidentMessage(String incidentMessage) {
        this.incidentMessage = incidentMessage;
    }

    @CamundaQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @CamundaQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @CamundaQueryParam(value="executionId")
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @CamundaQueryParam(value="activityId")
    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @CamundaQueryParam(value="causeIncidentId")
    public void setCauseIncidentId(String causeIncidentId) {
        this.causeIncidentId = causeIncidentId;
    }

    @CamundaQueryParam(value="rootCauseIncidentId")
    public void setRootCauseIncidentId(String rootCauseIncidentId) {
        this.rootCauseIncidentId = rootCauseIncidentId;
    }

    @CamundaQueryParam(value="configuration")
    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    @CamundaQueryParam(value="open", converter=BooleanConverter.class)
    public void setOpen(Boolean open) {
        this.open = open;
    }

    @CamundaQueryParam(value="resolved", converter=BooleanConverter.class)
    public void setResolved(Boolean resolved) {
        this.resolved = resolved;
    }

    @CamundaQueryParam(value="deleted", converter=BooleanConverter.class)
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    protected HistoricIncidentQuery createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createHistoricIncidentQuery();
    }

    protected void applyFilters(HistoricIncidentQuery query) {
        if (this.incidentId != null) {
            query.incidentId(this.incidentId);
        }
        if (this.incidentType != null) {
            query.incidentType(this.incidentType);
        }
        if (this.incidentMessage != null) {
            query.incidentMessage(this.incidentMessage);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.executionId != null) {
            query.executionId(this.executionId);
        }
        if (this.activityId != null) {
            query.activityId(this.activityId);
        }
        if (this.causeIncidentId != null) {
            query.causeIncidentId(this.causeIncidentId);
        }
        if (this.rootCauseIncidentId != null) {
            query.rootCauseIncidentId(this.rootCauseIncidentId);
        }
        if (this.configuration != null) {
            query.configuration(this.configuration);
        }
        if (this.open != null) {
            query.open();
        }
        if (this.resolved != null && this.resolved.booleanValue()) {
            query.resolved();
        }
        if (this.deleted != null && this.deleted.booleanValue()) {
            query.deleted();
        }
    }

    protected void applySortBy(HistoricIncidentQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_INCIDENT_ID)) {
            query.orderByIncidentId();
        } else if (sortBy.equals(SORT_BY_CREATE_TIME)) {
            query.orderByCreateTime();
        } else if (sortBy.equals(SORT_BY_END_TIME)) {
            query.orderByEndTime();
        } else if (sortBy.equals(SORT_BY_INCIDENT_TYPE)) {
            query.orderByIncidentType();
        } else if (sortBy.equals(SORT_BY_EXECUTION_ID)) {
            query.orderByExecutionId();
        } else if (sortBy.equals(SORT_BY_ACTIVITY_ID)) {
            query.orderByActivityId();
        } else if (sortBy.equals(SORT_BY_PROCESS_INSTANCE_ID)) {
            query.orderByProcessInstanceId();
        } else if (sortBy.equals(SORT_BY_PROCESS_DEFINITION_ID)) {
            query.orderByProcessDefinitionId();
        } else if (sortBy.equals(SORT_BY_CAUSE_INCIDENT_ID)) {
            query.orderByCauseIncidentId();
        } else if (sortBy.equals(SORT_BY_ROOT_CAUSE_INCIDENT_ID)) {
            query.orderByRootCauseIncidentId();
        } else if (sortBy.equals(SORT_BY_CONFIGURATION)) {
            query.orderByConfiguration();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_INCIDENT_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_CREATE_TIME);
        VALID_SORT_BY_VALUES.add(SORT_BY_END_TIME);
        VALID_SORT_BY_VALUES.add(SORT_BY_INCIDENT_TYPE);
        VALID_SORT_BY_VALUES.add(SORT_BY_EXECUTION_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_ACTIVITY_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_CAUSE_INCIDENT_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_ROOT_CAUSE_INCIDENT_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_CONFIGURATION);
    }
}

