/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.history;

import java.util.Map;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.rest.dto.VariableValueDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricDetailDto;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class HistoricVariableUpdateDto
extends HistoricDetailDto {
    protected String variableName;
    protected String variableType;
    protected Object value;
    protected Map<String, Object> valueInfo;
    protected int revision;
    protected String errorMessage;

    public String getVariableName() {
        return this.variableName;
    }

    public String getVariableType() {
        return this.variableType;
    }

    public Object getValue() {
        return this.value;
    }

    public int getRevision() {
        return this.revision;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Map<String, Object> getValueInfo() {
        return this.valueInfo;
    }

    public static HistoricVariableUpdateDto fromHistoricVariableUpdate(HistoricVariableUpdate historicVariableUpdate) {
        HistoricVariableUpdateDto dto = new HistoricVariableUpdateDto();
        dto.revision = historicVariableUpdate.getRevision();
        dto.variableName = historicVariableUpdate.getVariableName();
        if (historicVariableUpdate.getErrorMessage() == null) {
            VariableValueDto variableValueDto = VariableValueDto.fromTypedValue((TypedValue)historicVariableUpdate.getTypedValue());
            dto.value = variableValueDto.getValue();
            dto.variableType = variableValueDto.getType();
            dto.valueInfo = variableValueDto.getValueInfo();
        } else {
            dto.errorMessage = historicVariableUpdate.getErrorMessage();
            dto.variableType = VariableValueDto.toRestApiTypeName((String)historicVariableUpdate.getTypeName());
        }
        return dto;
    }
}

